/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.codec;

import java.nio.charset.StandardCharsets;
import org.apache.ignite.internal.lang.ByteArray;

public final class MetastoreKeyCodec {
    private final String keyPrefix;

    private MetastoreKeyCodec(String prefix) {
        this.keyPrefix = prefix;
    }

    public static MetastoreKeyCodec forPrefix(String prefix) {
        return new MetastoreKeyCodec(prefix);
    }

    public ByteArray prefix() {
        return new ByteArray(this.keyPrefix.getBytes(StandardCharsets.UTF_8));
    }

    public ByteArray serialize(String key) {
        return new ByteArray((this.keyPrefix + key).getBytes(StandardCharsets.UTF_8));
    }

    public String deserialize(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8).substring(this.keyPrefix.length());
    }
}

