/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key;

import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.security.auth.DestroyFailedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.security.configuration.SecurityConfiguration;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.security.key.IgniteKeyPair;
import org.gridgain.internal.security.key.IgnitePrivateKey;
import org.gridgain.internal.security.key.IgnitePublicKey;
import org.gridgain.internal.security.key.KeyConverter;
import org.gridgain.internal.security.key.KeyMetadata;
import org.gridgain.internal.security.key.NodeKeyManager;
import org.gridgain.internal.security.key.PublicKeyChain;
import org.gridgain.internal.security.key.PublicKeyChainCache;
import org.gridgain.internal.security.key.RsaKeyDecoder;
import org.gridgain.internal.security.key.RsaSecretGenerator;
import org.gridgain.internal.security.key.SecretGenerator;
import org.gridgain.internal.security.key.TimeUtils;
import org.gridgain.internal.security.key.exception.KeyExpiredException;
import org.gridgain.internal.security.key.exception.KeyNotFoundException;
import org.gridgain.internal.security.key.exception.KeyValidationException;
import org.gridgain.internal.security.key.store.PrivateKeyRecord;
import org.gridgain.internal.security.key.store.PrivateKeyStore;
import org.gridgain.internal.security.key.store.PublicKeyChainRecord;
import org.gridgain.internal.security.key.store.PublicKeyRecord;
import org.gridgain.internal.security.key.store.PublicKeyStore;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NodeKeyManagerImpl
implements NodeKeyManager {
    private static final IgniteLogger LOG = Loggers.forClass(NodeKeyManagerImpl.class);
    private final String nodeName;
    private final PrivateKeyStore privateKeyStore;
    private final PublicKeyStore publicKeyStore;
    private final SecurityConfiguration securityConfiguration;
    private final Supplier<Instant> currentTimeSupplier;
    private final PublicKeyChainCache<RSAPublicKey> publicKeyChainCache;
    private final SecretGenerator<RSAPrivateKey, RSAPublicKey> secretGenerator;
    private final KeyConverter<RSAPrivateKey, RSAPublicKey> keyConverter = new KeyConverter<RSAPrivateKey, RSAPublicKey>(new RsaKeyDecoder());
    private final Lock lock = new ReentrantLock();
    private final AtomicReference<IgnitePrivateKey<RSAPrivateKey>> lastPrivateKey = new AtomicReference();
    private final ScheduledExecutorService executorService;
    private volatile ScheduledFuture<?> keyRotationTask;

    public NodeKeyManagerImpl(String nodeName, PrivateKeyStore privateKeyStore, PublicKeyStore publicKeyStore, SecurityConfiguration securityConfiguration) {
        this.nodeName = nodeName;
        this.privateKeyStore = privateKeyStore;
        this.publicKeyStore = publicKeyStore;
        this.securityConfiguration = securityConfiguration;
        this.currentTimeSupplier = Instant::now;
        this.secretGenerator = new RsaSecretGenerator();
        this.publicKeyChainCache = new PublicKeyChainCache<RSAPublicKey>(this.keyConverter);
        this.executorService = NodeKeyManagerImpl.createExecutorService(nodeName);
    }

    @TestOnly
    public NodeKeyManagerImpl(String nodeName, PrivateKeyStore privateKeyStore, PublicKeyStore publicKeyStore, SecurityConfiguration securityConfiguration, Supplier<Instant> currentTimeSupplier, PublicKeyChainCache<RSAPublicKey> publicKeyChainCache, SecretGenerator<RSAPrivateKey, RSAPublicKey> secretGenerator) {
        this.nodeName = nodeName;
        this.privateKeyStore = privateKeyStore;
        this.publicKeyStore = publicKeyStore;
        this.securityConfiguration = securityConfiguration;
        this.currentTimeSupplier = currentTimeSupplier;
        this.publicKeyChainCache = publicKeyChainCache;
        this.secretGenerator = secretGenerator;
        this.executorService = NodeKeyManagerImpl.createExecutorService(nodeName);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.securityConfiguration.enabled().listen(ctx -> {
            if (Boolean.TRUE.equals(ctx.newValue())) {
                this.scheduleKeyRotation(this.retrieveLastKeyPair());
            } else {
                this.cancelKeyRotationScheduler();
            }
            return CompletableFutures.nullCompletedFuture();
        });
        this.publicKeyStore.registerPrefixWatch(this.publicKeyChainCache);
        this.publicKeyStore.getAllPublicKeyChains().forEach((nodeName, record) -> this.publicKeyChainCache.put((String)nodeName, this.keyConverter.publicKeyChainFromRecord((PublicKeyChainRecord)record)));
        IgniteKeyPair<RSAPrivateKey, RSAPublicKey> retrievedPair = this.retrieveLastKeyPair();
        if (retrievedPair != null) {
            IgnitePrivateKey<RSAPrivateKey> retrievedPrivateKey = new IgnitePrivateKey<RSAPrivateKey>(retrievedPair.privateKey(), retrievedPair.metadata());
            this.lastPrivateKey.set(retrievedPrivateKey);
        }
        if (((Boolean)this.securityConfiguration.enabled().value()).booleanValue()) {
            this.scheduleKeyRotation(retrievedPair);
        }
        this.securityConfiguration.jwt().keyTtl().listen(ctx -> {
            if (((Boolean)this.securityConfiguration.enabled().value()).booleanValue()) {
                this.cancelKeyRotationScheduler();
                this.scheduleKeyRotationTask(0L);
            }
            return CompletableFutures.nullCompletedFuture();
        });
        return CompletableFutures.nullCompletedFuture();
    }

    private void cancelKeyRotationScheduler() {
        if (this.keyRotationTask != null) {
            this.keyRotationTask.cancel(false);
            this.keyRotationTask = null;
        }
    }

    private void scheduleKeyRotation(@Nullable IgniteKeyPair<RSAPrivateKey, RSAPublicKey> retrievedPair) {
        long initialDelay = this.computeInitialDelay(retrievedPair);
        if (initialDelay == 0L) {
            LOG.info("No valid key pair was found, a new key pair will be generated immediately", new Object[0]);
        } else {
            LOG.info("Valid key pair was found, a new key pair will be generated in {} seconds", new Object[]{initialDelay / 1000L});
        }
        this.scheduleKeyRotationTask(initialDelay);
    }

    private long computeInitialDelay(@Nullable IgniteKeyPair<RSAPrivateKey, RSAPublicKey> keyPair) {
        if (keyPair == null) {
            return 0L;
        }
        KeyMetadata metadata = keyPair.metadata();
        Instant newExpirationTime = metadata.issuedAt().plusMillis((Long)this.securityConfiguration.jwt().keyTtl().value());
        if (!newExpirationTime.equals(metadata.expirationTime())) {
            return 0L;
        }
        long millisToExpiration = Duration.between(this.currentTimeSupplier.get(), newExpirationTime).toMillis();
        return Math.max(millisToExpiration, 0L);
    }

    private void scheduleKeyRotationTask(long initialDelay) {
        Runnable task = () -> {
            try {
                this.rotateKey(this.lastPrivateKey.get());
            }
            catch (Exception e) {
                LOG.error("Failed to rotate the key pair", (Throwable)e);
            }
        };
        this.keyRotationTask = this.executorService.scheduleAtFixedRate(task, initialDelay, (Long)this.securityConfiguration.jwt().keyTtl().value(), TimeUnit.MILLISECONDS);
    }

    @Nullable
    private IgniteKeyPair<RSAPrivateKey, RSAPublicKey> retrieveLastKeyPair() {
        try {
            Instant now = this.currentTimeSupplier.get();
            PublicKeyChainRecord publicKeyChainRecord = this.publicKeyStore.getPublicKeyChain(this.nodeName);
            if (publicKeyChainRecord == null) {
                return null;
            }
            PublicKeyRecord publicKeyRecord = publicKeyChainRecord.keyRecord();
            PrivateKeyRecord privateKeyRecord = this.privateKeyStore.getPrivateKey();
            if (privateKeyRecord == null) {
                return null;
            }
            NodeKeyManagerImpl.validateKeyPair(privateKeyRecord, publicKeyRecord, now);
            IgnitePrivateKey<RSAPrivateKey> privateKey = this.keyConverter.privateKeyFromRecord(privateKeyRecord);
            IgnitePublicKey<RSAPublicKey> publicKey = this.keyConverter.publicKeyFromRecord(publicKeyRecord);
            return new IgniteKeyPair<RSAPrivateKey, RSAPublicKey>(privateKey.key(), publicKey.key(), privateKey.metadata());
        }
        catch (Exception e) {
            LOG.info("Failed to retrieve the last key pair", (Throwable)e);
            return null;
        }
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public IgnitePublicKey<RSAPublicKey> getPublicKey(String nodeName, int id) {
        PublicKeyChain<RSAPublicKey> publicKeyChain = this.publicKeyChainCache.get(nodeName);
        if (publicKeyChain == null) {
            throw new KeyNotFoundException("Public key for node: " + nodeName + " was not found");
        }
        IgnitePublicKey<RSAPublicKey> currentKey = publicKeyChain.currentKey();
        if (currentKey.metadata().id() == id) {
            return currentKey;
        }
        IgnitePublicKey<RSAPublicKey> prevKey = publicKeyChain.prevKey();
        if (prevKey != null && prevKey.metadata().id() == id) {
            return prevKey;
        }
        throw new KeyExpiredException("Public key for node: " + nodeName + " with id: " + id + " was not found");
    }

    @Override
    public IgnitePrivateKey<RSAPrivateKey> getLocalPrivateKey() {
        IgnitePrivateKey<RSAPrivateKey> key = this.lastPrivateKey.get();
        return key != null && NodeKeyManagerImpl.isKeyValidAt(key.metadata(), this.currentTimeSupplier.get()) ? key : this.rotateKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgnitePrivateKey<RSAPrivateKey> rotateKey(@Nullable IgnitePrivateKey<RSAPrivateKey> currentKey) {
        this.lock.lock();
        try {
            IgnitePrivateKey<RSAPrivateKey> currentKey2 = this.lastPrivateKey.get();
            if (currentKey2 != null && currentKey2 != currentKey) {
                IgnitePrivateKey<RSAPrivateKey> ignitePrivateKey = currentKey2;
                return ignitePrivateKey;
            }
            IgnitePrivateKey<RSAPrivateKey> ignitePrivateKey = this.rotateKey0(NodeKeyManagerImpl.nextId(currentKey)).join();
            return ignitePrivateKey;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static int nextId(@Nullable IgnitePrivateKey<RSAPrivateKey> currentKey) {
        if (currentKey != null && currentKey.metadata().id() != Integer.MAX_VALUE) {
            return currentKey.metadata().id() + 1;
        }
        return 1;
    }

    private CompletableFuture<IgnitePrivateKey<RSAPrivateKey>> rotateKey0(int id) {
        IgniteKeyPair<RSAPrivateKey, RSAPublicKey> pair = this.secretGenerator.generateKeyPair(id, (Long)this.securityConfiguration.jwt().keyTtl().value());
        IgnitePrivateKey<RSAPrivateKey> privateKey = new IgnitePrivateKey<RSAPrivateKey>(pair.privateKey(), pair.metadata());
        IgnitePublicKey<RSAPublicKey> publicKey = new IgnitePublicKey<RSAPublicKey>(pair.publicKey(), pair.metadata());
        PublicKeyRecord publicKeyRecord = this.keyConverter.publicKeyRecordFromKey(publicKey);
        PublicKeyChainRecord publicKeyChainRecord = this.publicKeyStore.getPublicKeyChain(this.nodeName);
        PublicKeyChainRecord updatedPublicKeyChainRecord = publicKeyChainRecord != null ? publicKeyChainRecord.merge(publicKeyRecord) : new PublicKeyChainRecord(publicKeyRecord, null);
        this.privateKeyStore.putPrivateKey(this.keyConverter.privateKeyRecordFromKey(privateKey));
        return ((CompletableFuture)this.publicKeyStore.updatePublicKeyChain(this.nodeName, updatedPublicKeyChainRecord).thenApply(unused -> privateKey)).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                LOG.error("Failed to generate new key", throwable);
            } else {
                LOG.info("New key pair was generated", new Object[0]);
                this.publicKeyChainCache.updateRecord(this.nodeName, updatedPublicKeyChainRecord);
                IgnitePrivateKey<RSAPrivateKey> prevPrivateKey = this.lastPrivateKey.getAndSet(privateKey);
                if (prevPrivateKey != null) {
                    try {
                        prevPrivateKey.key().destroy();
                    }
                    catch (DestroyFailedException destroyFailedException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static void validateKeyPair(PrivateKeyRecord privateKey, PublicKeyRecord publicKey, Instant validAt) {
        if (!privateKey.metadata().equals(publicKey.metadata())) {
            throw new KeyValidationException("Private and public keys have different metadata");
        }
    }

    private static boolean isKeyValidAt(KeyMetadata metadata, Instant validAt) {
        return TimeUtils.isWithinRange(validAt, metadata.issuedAt(), metadata.expirationTime());
    }

    private static ScheduledExecutorService createExecutorService(String nodeName) {
        return Executors.newScheduledThreadPool(1, (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"jwt-key-manager-executor", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
    }

    @TestOnly
    public IgnitePrivateKey<RSAPrivateKey> forceKeyRotation() {
        return this.rotateKey(this.lastPrivateKey.get());
    }

    @TestOnly
    public ScheduledFuture<?> keyRotationTask() {
        return this.keyRotationTask;
    }
}

