/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key.store.serde;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.gridgain.internal.security.key.exception.KeySerDeException;
import org.gridgain.internal.security.key.store.PublicKeyChainRecord;
import org.gridgain.internal.security.key.store.PublicKeyRecord;
import org.gridgain.internal.security.key.store.serde.PublicKeyRecordSerDe;

public final class KeyChainRecordSerDe {
    private KeyChainRecordSerDe() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(PublicKeyChainRecord record) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                byte[] currentKeySerialized = PublicKeyRecordSerDe.serialize(record.keyRecord());
                dos.writeInt(currentKeySerialized.length);
                dos.write(currentKeySerialized);
                if (record.prevKeyRecord() != null) {
                    byte[] prevKeySerialized = PublicKeyRecordSerDe.serialize(record.prevKeyRecord());
                    dos.writeInt(prevKeySerialized.length);
                    dos.write(prevKeySerialized);
                } else {
                    dos.writeInt(0);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new KeySerDeException("Serialization error", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PublicKeyChainRecord deserialize(byte[] bytes) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            PublicKeyChainRecord publicKeyChainRecord;
            try (DataInputStream dis = new DataInputStream(bais);){
                int currentKeyLength = dis.readInt();
                byte[] currentKeyBytes = new byte[currentKeyLength];
                dis.readFully(currentKeyBytes);
                PublicKeyRecord currentKeyRecord = PublicKeyRecordSerDe.deserialize(currentKeyBytes);
                PublicKeyRecord prevKeyRecord = null;
                int prevKeyLength = dis.readInt();
                if (prevKeyLength > 0) {
                    byte[] prevKeyBytes = new byte[prevKeyLength];
                    dis.readFully(prevKeyBytes);
                    prevKeyRecord = PublicKeyRecordSerDe.deserialize(prevKeyBytes);
                }
                publicKeyChainRecord = new PublicKeyChainRecord(currentKeyRecord, prevKeyRecord);
            }
            return publicKeyChainRecord;
        }
        catch (IOException e) {
            throw new KeySerDeException("Deserialization error", e);
        }
    }
}

