/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.event.EventProducer;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.security.authentication.UserDetails;
import org.apache.ignite.internal.security.authentication.event.AuthenticationEvent;
import org.apache.ignite.internal.security.authentication.event.AuthenticationEventParameters;
import org.apache.ignite.internal.security.authentication.event.UserEventParameters;
import org.apache.ignite.internal.security.jwt.configuration.JwtConfiguration;
import org.apache.ignite.internal.util.ClusterNameProvider;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.NodeNameProvider;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.jwt.BlockList;
import org.gridgain.internal.security.jwt.TokenManager;
import org.gridgain.internal.security.jwt.exception.JwtValidationException;
import org.gridgain.internal.security.key.IgnitePrivateKey;
import org.gridgain.internal.security.key.IgnitePublicKey;
import org.gridgain.internal.security.key.NodeKeyManager;
import org.gridgain.internal.security.key.exception.KeyExpiredException;

public class JwtTokenManager
implements TokenManager {
    private static final String[] REQUIRED_CLAIMS = new String[]{"gic", "gin", "sub", "gur", "kid"};
    private final ClusterNameProvider clusterNameProvider;
    private final NodeNameProvider nodeNameProvider;
    private final JwtConfiguration jwtConfiguration;
    private final NodeKeyManager keyManager;
    private final BlockList blockList;
    private final Authorizer authorizer;
    private final EventProducer<AuthenticationEvent, AuthenticationEventParameters> authEventProducer;
    private final EventListener<UserEventParameters> userRemovedListener = this::onUserRemoved;

    public JwtTokenManager(ClusterNameProvider clusterNameProvider, NodeNameProvider nodeNameProvider, JwtConfiguration jwtConfiguration, NodeKeyManager keyManager, MetaStorageManager metaStorageManager, Authorizer authorizer, EventProducer<AuthenticationEvent, AuthenticationEventParameters> authEventProducer) {
        this.clusterNameProvider = clusterNameProvider;
        this.nodeNameProvider = nodeNameProvider;
        this.jwtConfiguration = jwtConfiguration;
        this.keyManager = keyManager;
        this.authorizer = authorizer;
        this.blockList = new BlockList(metaStorageManager, jwtConfiguration, nodeNameProvider.getName());
        this.authEventProducer = authEventProducer;
    }

    @Override
    public String issueToken(UserDetails userDetails) {
        Instant issuedAt = Instant.now();
        IgnitePrivateKey<RSAPrivateKey> privateKey = this.keyManager.getLocalPrivateKey();
        Algorithm algorithm = Algorithm.RSA256(null, (RSAPrivateKey)privateKey.key());
        JWTCreator.Builder builder = JWT.create().withSubject(userDetails.username()).withIssuedAt(issuedAt).withExpiresAt(issuedAt.plusMillis((Long)this.jwtConfiguration.ttl().value())).withClaim("gur", new ArrayList(userDetails.roles())).withClaim("gic", this.clusterNameProvider.getName()).withClaim("gin", this.nodeNameProvider.getName()).withClaim("kid", Integer.valueOf(privateKey.metadata().id()));
        return builder.sign(algorithm);
    }

    @Override
    public UserDetails validateAndExtractDetails(String token) {
        DecodedJWT jwt = this.parseToken(token);
        if (this.isRevoked(token, jwt.getSubject(), jwt.getIssuedAtAsInstant())) {
            throw new JwtValidationException("Failed to validate JWT token: token is revoked");
        }
        List roles = jwt.getClaim("gur").asList(String.class);
        return new UserDetails(jwt.getSubject(), "Unknown", new HashSet(roles));
    }

    private DecodedJWT parseToken(String token) {
        try {
            DecodedJWT decodedJwt = JWT.decode((String)token);
            JwtTokenManager.verifyClaims(decodedJwt);
            this.verifySignature(decodedJwt);
            return decodedJwt;
        }
        catch (JwtValidationException e) {
            throw e;
        }
        catch (JWTDecodeException e) {
            throw new JwtValidationException("Failed to decode JWT token", e);
        }
        catch (SignatureVerificationException e) {
            throw new JwtValidationException("Failed to verify JWT token signature", e);
        }
        catch (KeyExpiredException e) {
            throw new JwtValidationException("Failed to validate JWT token: key is expired", (Throwable)((Object)e));
        }
        catch (TokenExpiredException e) {
            throw new JwtValidationException("Failed to validate JWT token: token is expired on " + e.getExpiredOn(), e);
        }
        catch (Exception e) {
            throw new JwtValidationException("Failed to validate JWT token: " + e.getMessage(), e);
        }
    }

    private static void verifyClaims(DecodedJWT decodedJwt) {
        for (String requiredClaim : REQUIRED_CLAIMS) {
            if (!decodedJwt.getClaim(requiredClaim).isMissing()) continue;
            throw new JwtValidationException("Failed to validate JWT token: claim " + requiredClaim + " is missing");
        }
    }

    private void verifySignature(DecodedJWT decodedJwt) {
        int id = decodedJwt.getClaim("kid").asInt();
        String nodeName = decodedJwt.getClaim("gin").asString();
        IgnitePublicKey<RSAPublicKey> publicKey = this.keyManager.getPublicKey(nodeName, id);
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey.key(), null);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
        verifier.verify(decodedJwt);
    }

    private boolean isRevoked(String token, String username, Instant issuedAt) {
        return this.blockList.isTokenRevoked(token, username, issuedAt);
    }

    @Override
    public CompletableFuture<Void> revokeToken(String token) {
        DecodedJWT decodedJwt = this.parseToken(token);
        String username = decodedJwt.getSubject();
        Privilege privilege = Privilege.builder().action(Action.REVOKE_TOKEN).selector(Selector.user((String)username)).build();
        return this.authorizer.authorizeThenCompose(privilege, () -> this.blockList.revokeToken(decodedJwt.getToken(), decodedJwt.getExpiresAtAsInstant()));
    }

    @Override
    public CompletableFuture<Void> revokeAllTokens(String username) {
        Privilege privilege = Privilege.builder().action(Action.REVOKE_TOKEN).selector(Selector.user((String)username)).build();
        return this.authorizer.authorizeThenCompose(privilege, () -> this.blockList.revokeTokensIssuedBefore(username, Instant.now()));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.blockList.start();
        this.authEventProducer.listen((Event)AuthenticationEvent.USER_REMOVED, this.userRemovedListener);
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Boolean> onUserRemoved(UserEventParameters parameters) {
        return ((CompletableFuture)GridGainSecurity.bypass(() -> this.revokeAllTokens(parameters.username()))).thenApply(ignored -> false);
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.blockList.stop();
        this.authEventProducer.removeListener((Event)AuthenticationEvent.USER_REMOVED, this.userRemovedListener);
        return CompletableFutures.nullCompletedFuture();
    }
}

