/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key.store.serde;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.gridgain.internal.security.key.exception.KeySerDeException;
import org.gridgain.internal.security.key.store.KeyMetadataRecord;
import org.gridgain.internal.security.key.store.PublicKeyRecord;
import org.gridgain.internal.security.key.store.serde.MetadataKeyRecordSerDe;

public final class PublicKeyRecordSerDe {
    private PublicKeyRecordSerDe() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(PublicKeyRecord record) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                dos.writeInt(record.keyBytes().length);
                dos.write(record.keyBytes());
                byte[] metadataBytes = MetadataKeyRecordSerDe.serialize(record.metadata());
                dos.writeInt(metadataBytes.length);
                dos.write(metadataBytes);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new KeySerDeException("Failed to serialize key record", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PublicKeyRecord deserialize(byte[] bytes) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            PublicKeyRecord publicKeyRecord;
            try (DataInputStream dis = new DataInputStream(bais);){
                int keyLength = dis.readInt();
                byte[] key = new byte[keyLength];
                dis.readFully(key);
                int metadataLength = dis.readInt();
                byte[] metadataBytes = new byte[metadataLength];
                dis.readFully(metadataBytes);
                KeyMetadataRecord metadata = MetadataKeyRecordSerDe.deserialize(metadataBytes);
                publicKeyRecord = new PublicKeyRecord(key, metadata);
            }
            return publicKeyRecord;
        }
        catch (IOException e) {
            throw new KeySerDeException("Failed to deserialize key record", e);
        }
    }
}

