/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.key.store;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.util.Cursor;
import org.gridgain.internal.security.key.store.PublicKeyChainRecord;
import org.gridgain.internal.security.key.store.serde.KeyChainRecordSerDe;
import org.gridgain.internal.security.key.store.serde.MetastoreKeySerDe;
import org.jetbrains.annotations.Nullable;

public class PublicKeyStore {
    private final MetaStorageManager metaStorage;

    public PublicKeyStore(MetaStorageManager metaStorage) {
        this.metaStorage = metaStorage;
    }

    public void registerPrefixWatch(WatchListener listener) {
        this.metaStorage.registerPrefixWatch(MetastoreKeySerDe.prefix(), listener);
    }

    public Map<String, PublicKeyChainRecord> getAllPublicKeyChains() {
        try (Cursor cursor = this.metaStorage.prefixLocally(MetastoreKeySerDe.prefix(), Long.MAX_VALUE);){
            Map<String, PublicKeyChainRecord> map = cursor.stream().filter(entry -> !entry.empty() && !entry.tombstone()).collect(Collectors.toMap(entry -> MetastoreKeySerDe.deserialize(entry.key()), entry -> KeyChainRecordSerDe.deserialize(entry.value())));
            return map;
        }
    }

    @Nullable
    public PublicKeyChainRecord getPublicKeyChain(String nodeName) {
        Entry entry = this.metaStorage.getLocally(MetastoreKeySerDe.serialize(nodeName), Long.MAX_VALUE);
        if (entry.empty() || entry.tombstone()) {
            return null;
        }
        return KeyChainRecordSerDe.deserialize(entry.value());
    }

    public CompletableFuture<Void> updatePublicKeyChain(String nodeName, PublicKeyChainRecord historyRecord) {
        ByteArray key = MetastoreKeySerDe.serialize(nodeName);
        byte[] value = KeyChainRecordSerDe.serialize(historyRecord);
        return this.metaStorage.put(key, value);
    }
}

