/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc.dialect;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gridgain.cache.store.jdbc.dialect.BasicJdbcDialect;

public class PostgresqlDialect
extends BasicJdbcDialect {
    @Override
    public boolean hasMerge() {
        return true;
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        Collection cols = Stream.concat(keyCols.stream(), uniqCols.stream()).collect(Collectors.toList());
        String colsLst = PostgresqlDialect.mkString(cols, ", ");
        String match = PostgresqlDialect.mkString(keyCols, col -> String.format("t.%s=v.%s", col, col), "", " AND ", "");
        String setCols = PostgresqlDialect.mkString(uniqCols, col -> String.format("%s = v.%s", col, col), "", ", ", "");
        String valuesCols = PostgresqlDialect.mkString(cols, col -> "v." + col, "", ", ", "");
        return String.format("MERGE INTO %s t USING (VALUES(%s)) AS v (%s)  ON %s WHEN MATCHED THEN  UPDATE SET %s WHEN NOT MATCHED THEN  INSERT (%s) VALUES (%s);", fullTblName, PostgresqlDialect.repeat("?", cols.size(), "", ",", ""), colsLst, match, setCols, colsLst, valuesCols);
    }
}

