/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc.dialect;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gridgain.cache.store.jdbc.dialect.BasicJdbcDialect;

public class OracleDialect
extends BasicJdbcDialect {
    @Override
    public boolean hasMerge() {
        return true;
    }

    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = OracleDialect.mkString(keyCols, ",");
        return String.format("SELECT %1$s FROM (SELECT %1$s, ROWNUM AS rn FROM (SELECT %1$s FROM %2$s ORDER BY %1$s)) WHERE mod(rn, ?) = 0", cols, fullTblName);
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        Collection cols = Stream.concat(keyCols.stream(), uniqCols.stream()).collect(Collectors.toList());
        String colsLst = OracleDialect.mkString(cols, ", ");
        String selCols = OracleDialect.mkString(cols, col -> String.format("? AS %s", col), "", ", ", "");
        String match = OracleDialect.mkString(keyCols, col -> String.format("t.%s=v.%s", col, col), "(", " AND ", ")");
        String setCols = OracleDialect.mkString(uniqCols, col -> String.format("t.%s = v.%s", col, col), "", ", ", "");
        String valuesCols = OracleDialect.mkString(cols, col -> "v." + col, "", ", ", "");
        return String.format("MERGE INTO %s t USING (SELECT %s FROM dual) v  ON %s WHEN MATCHED THEN  UPDATE SET %s WHEN NOT MATCHED THEN  INSERT (%s) VALUES (%s)", fullTblName, selCols, match, setCols, colsLst, valuesCols);
    }
}

