/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.Tuple;
import org.gridgain.cache.store.jdbc.JdbcCacheStore;
import org.gridgain.cache.store.jdbc.JdbcCacheStoreConfigurationException;
import org.gridgain.cache.store.jdbc.JdbcType;
import org.gridgain.cache.store.jdbc.JdbcTypeField;
import org.jetbrains.annotations.Nullable;

public class JdbcTupleCacheStore
extends JdbcCacheStore<Tuple, Tuple> {
    JdbcTupleCacheStore() {
    }

    @Override
    @Nullable
    protected Object extractParameter(String typeName, JdbcCacheStore.TypeKind typeKind, String fieldName, Object obj) throws IgniteException {
        if (obj instanceof Tuple) {
            return ((Tuple)obj).value(fieldName);
        }
        throw new JdbcCacheStoreConfigurationException("Failed to read property value from non tuple object [class=" + obj.getClass() + ", property=" + fieldName + "]");
    }

    @Override
    protected <R> R buildObject(String typeName, JdbcCacheStore.TypeKind typeKind, JdbcTypeField[] fields, Map<String, Integer> loadColIndexes, ResultSet rs) throws IgniteException {
        try {
            Tuple tuple = Tuple.create();
            for (JdbcTypeField field : fields) {
                Integer colIdx = JdbcTupleCacheStore.columnIndex(loadColIndexes, field.getDatabaseFieldName());
                Object colVal = this.transformer.getColumnValue(rs, colIdx, field.getJavaFieldType());
                tuple.set(field.getJavaFieldName(), colVal);
            }
            return (R)tuple;
        }
        catch (SQLException e) {
            throw new JdbcCacheStoreConfigurationException("Failed to read object: " + typeName, e);
        }
    }

    @Override
    protected void prepareBuilders(JdbcType types) throws IgniteException {
    }

    public String toString() {
        return S.toString(JdbcTupleCacheStore.class, (Object)this);
    }

    @Override
    protected JdbcCacheStore.TypeKind kindForName(String type) {
        return JdbcCacheStore.TypeKind.TUPLE;
    }
}

