/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.cache.store.jdbc.JdbcCacheStore;
import org.gridgain.cache.store.jdbc.JdbcCacheStoreConfigurationException;
import org.gridgain.cache.store.jdbc.JdbcType;
import org.gridgain.cache.store.jdbc.JdbcTypeField;
import org.jetbrains.annotations.Nullable;

public class JdbcPojoCacheStore<K, V>
extends JdbcCacheStore<K, V> {
    private final Map<String, PojoPropertiesCache> pojoProps = IgniteUtils.newHashMap((int)2);

    JdbcPojoCacheStore() {
    }

    @Override
    @Nullable
    protected Object extractParameter(String typeName, JdbcCacheStore.TypeKind typeKind, String fieldName, Object obj) {
        if (Objects.requireNonNull(typeKind) == JdbcCacheStore.TypeKind.BUILT_IN) {
            return obj;
        }
        return this.extractPojoParameter(typeName, fieldName, obj);
    }

    @Override
    protected <R> R buildObject(String typeName, JdbcCacheStore.TypeKind typeKind, JdbcTypeField[] flds, Map<String, Integer> loadColIndexes, ResultSet rs) {
        if (Objects.requireNonNull(typeKind) == JdbcCacheStore.TypeKind.BUILT_IN) {
            return (R)this.buildBuiltinObject(typeName, flds, loadColIndexes, rs);
        }
        return (R)this.buildPojoObject(typeName, flds, loadColIndexes, rs);
    }

    @Override
    protected void prepareBuilders(JdbcType type) {
        String valTypeName;
        JdbcCacheStore.TypeKind valKind;
        String keyTypeName = type.getKeyType();
        JdbcCacheStore.TypeKind keyKind = this.kindForName(keyTypeName);
        if (keyKind == JdbcCacheStore.TypeKind.POJO) {
            this.pojoProps.put(keyTypeName, new PojoPropertiesCache(keyTypeName, type.getKeyFields()));
        }
        if ((valKind = this.kindForName(valTypeName = type.getValueType())) == JdbcCacheStore.TypeKind.POJO) {
            this.pojoProps.put(valTypeName, new PojoPropertiesCache(valTypeName, type.getValueFields()));
        }
    }

    public String toString() {
        return S.toString(JdbcPojoCacheStore.class, (Object)this);
    }

    @Nullable
    private Object extractPojoParameter(String typeName, String fldName, Object obj) {
        try {
            Map<String, PojoPropertiesCache> cacheProps = this.pojoProps;
            if (cacheProps == null) {
                throw new JdbcCacheStoreConfigurationException("Failed to find POJO type metadata for table: " + this.mapping.fullTableName());
            }
            PojoPropertiesCache ppc = cacheProps.get(typeName);
            if (ppc == null) {
                throw new JdbcCacheStoreConfigurationException("Failed to find POJO type metadata for type: " + typeName);
            }
            ClassProperty prop = ppc.props.get(fldName);
            if (prop == null) {
                throw new JdbcCacheStoreConfigurationException("Failed to find property in POJO class [class=" + typeName + ", prop=" + fldName + "]");
            }
            return prop.get(obj);
        }
        catch (Exception e) {
            throw new JdbcCacheStoreConfigurationException("Failed to read object property [table=" + this.mapping.fullTableName() + ", type=" + typeName + ", prop=" + fldName + "]", e);
        }
    }

    private Object buildBuiltinObject(String typeName, JdbcTypeField[] fields, Map<String, Integer> loadColIdxs, ResultSet rs) {
        JdbcTypeField field = fields[0];
        try {
            Integer colIdx = JdbcPojoCacheStore.columnIndex(loadColIdxs, field.getDatabaseFieldName());
            return this.transformer.getColumnValue(rs, colIdx, field.getJavaFieldType());
        }
        catch (SQLException e) {
            throw new JdbcCacheStoreConfigurationException("Failed to read object: [cls=" + typeName + ", prop=" + field + "]", e);
        }
    }

    private Object buildPojoObject(String typeName, JdbcTypeField[] flds, Map<String, Integer> loadColIdxs, ResultSet rs) {
        PojoPropertiesCache ppc = this.pojoProps.get(typeName);
        if (ppc == null) {
            throw new JdbcCacheStoreConfigurationException("Failed to find POJO type metadata for type: " + typeName);
        }
        try {
            Object obj = ppc.ctor.newInstance(new Object[0]);
            for (JdbcTypeField fld : flds) {
                String fldJavaName = fld.getJavaFieldName();
                ClassProperty prop = ppc.props.get(fldJavaName);
                if (prop == null) {
                    throw new IllegalStateException("Failed to find property in POJO class [type=" + typeName + ", prop=" + fldJavaName + "]");
                }
                String dbName = fld.getDatabaseFieldName();
                Integer colIdx = JdbcPojoCacheStore.columnIndex(loadColIdxs, dbName);
                try {
                    Object colVal = this.transformer.getColumnValue(rs, colIdx, fld.getJavaFieldType());
                    try {
                        prop.set(obj, colVal);
                    }
                    catch (Exception e) {
                        throw new JdbcCacheStoreConfigurationException("Failed to set property in POJO class [type=" + typeName + ", colIdx=" + colIdx + ", prop=" + fld + ", dbValCls=" + colVal.getClass().getName() + ", dbVal=" + colVal + "]", e);
                    }
                }
                catch (SQLException e) {
                    throw new JdbcCacheStoreConfigurationException("Failed to read object property [type=" + typeName + ", colIdx=" + colIdx + ", prop=" + fld + "]", e);
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new JdbcCacheStoreConfigurationException("Failed to construct instance of class: " + typeName, e);
        }
    }

    @Override
    protected JdbcCacheStore.TypeKind kindForName(String type) {
        if (BUILT_IN_TYPES.contains(type)) {
            return JdbcCacheStore.TypeKind.BUILT_IN;
        }
        try {
            Class.forName(type);
            return JdbcCacheStore.TypeKind.POJO;
        }
        catch (ClassNotFoundException e) {
            throw new JdbcCacheStoreConfigurationException("Failed to find class " + type + " (make sure the class is present in classPath or use BinaryMarshaller)", e);
        }
    }

    private static class PojoPropertiesCache {
        private final Class<?> cls;
        private final Constructor ctor;
        private final Map<String, ClassProperty> props;

        private PojoPropertiesCache(String clsName, JdbcTypeField[] jdbcFlds) {
            try {
                this.cls = Class.forName(clsName);
                this.ctor = this.cls.getDeclaredConstructor(new Class[0]);
                if (!this.ctor.canAccess(null)) {
                    this.ctor.setAccessible(true);
                }
            }
            catch (ClassNotFoundException e) {
                throw new JdbcCacheStoreConfigurationException("Failed to find class: " + clsName, e);
            }
            catch (NoSuchMethodException e) {
                throw new JdbcCacheStoreConfigurationException("Failed to find default constructor for class: " + clsName, e);
            }
            this.props = IgniteUtils.newHashMap((int)jdbcFlds.length);
            for (JdbcTypeField jdbcFld : jdbcFlds) {
                Method setter;
                String fldName = jdbcFld.getJavaFieldName();
                String mthName = PojoPropertiesCache.capitalFirst(fldName);
                Method getter = PojoPropertiesCache.methodByName(this.cls, "get" + mthName, new Class[0]);
                if (getter == null) {
                    getter = PojoPropertiesCache.methodByName(this.cls, "is" + mthName, new Class[0]);
                }
                if (getter == null) {
                    getter = PojoPropertiesCache.methodByName(this.cls, fldName, new Class[0]);
                }
                if ((setter = PojoPropertiesCache.methodByName(this.cls, "set" + mthName, jdbcFld.getJavaFieldType())) == null) {
                    setter = PojoPropertiesCache.methodByName(this.cls, fldName, jdbcFld.getJavaFieldType());
                }
                if (getter != null && setter != null) {
                    this.props.put(fldName, new ClassProperty(getter, setter, null));
                    continue;
                }
                try {
                    this.props.put(fldName, new ClassProperty(null, null, this.cls.getDeclaredField(fldName)));
                }
                catch (NoSuchFieldException ignored) {
                    throw new JdbcCacheStoreConfigurationException("Failed to find property in POJO class [class=" + clsName + ", prop=" + fldName + "]");
                }
            }
        }

        @Nullable
        private static String capitalFirst(@Nullable String str) {
            return str == null ? null : (str.isEmpty() ? "" : Character.toUpperCase(str.charAt(0)) + str.substring(1));
        }

        private static Method methodByName(Class<?> cls, String name, Class<?> ... paramTypes) {
            try {
                return cls.getMethod(name, paramTypes);
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
        }
    }

    private static class ClassProperty {
        private final Method getter;
        private final Method setter;
        private final Field field;

        private ClassProperty(@Nullable Method getter, @Nullable Method setter, @Nullable Field field) {
            this.getter = getter;
            this.setter = setter;
            this.field = field;
            if (getter != null) {
                getter.setAccessible(true);
            }
            if (setter != null) {
                setter.setAccessible(true);
            }
            if (field != null) {
                field.setAccessible(true);
            }
        }

        private Object get(Object obj) throws IllegalAccessException, InvocationTargetException {
            if (this.getter != null) {
                return this.getter.invoke(obj, new Object[0]);
            }
            if (this.field != null) {
                return this.field.get(obj);
            }
            throw new IllegalAccessException("Failed to get value from property. Getter and field was not initialized.");
        }

        private void set(Object obj, Object val) throws IllegalAccessException, InvocationTargetException {
            if (this.setter != null) {
                this.setter.invoke(obj, val);
            } else if (this.field != null) {
                this.field.set(obj, val);
            } else {
                throw new IllegalAccessException("Failed to set new value from property.  Setter and field was not initialized.");
            }
        }
    }
}

