/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc;

import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.cache.CacheStoreSession;
import org.apache.ignite.tx.Transaction;
import org.gridgain.cache.store.jdbc.JdbcCacheStore;

public class JdbcCacheStoreSession
implements CacheStoreSession {
    private Transaction transaction;
    private final Map<JdbcCacheStore<?, ?>, Connection> connections = new ConcurrentHashMap();

    public CompletableFuture<Void> finishAsync(boolean commit) {
        CompletableFuture[] futures = (CompletableFuture[])this.connections.keySet().stream().map(store -> store.sessionEnd(commit, this)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    Connection getConnection(JdbcCacheStore<?, ?> store) {
        return this.connections.get(store);
    }

    void setConnection(JdbcCacheStore<?, ?> store, Connection connection) {
        this.connections.put(store, connection);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }
}

