/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.ignite.cache.CacheStore;
import org.apache.ignite.cache.CacheStoreSession;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.IgniteException;
import org.gridgain.cache.store.jdbc.JdbcCacheStoreAccessException;
import org.gridgain.cache.store.jdbc.JdbcCacheStoreConfigurationException;
import org.gridgain.cache.store.jdbc.JdbcCacheStoreSession;
import org.gridgain.cache.store.jdbc.JdbcType;
import org.gridgain.cache.store.jdbc.JdbcTypeField;
import org.gridgain.cache.store.jdbc.JdbcTypesDefaultTransformer;
import org.gridgain.cache.store.jdbc.JdbcTypesTransformer;
import org.gridgain.cache.store.jdbc.dialect.BasicJdbcDialect;
import org.gridgain.cache.store.jdbc.dialect.Db2Dialect;
import org.gridgain.cache.store.jdbc.dialect.H2Dialect;
import org.gridgain.cache.store.jdbc.dialect.JdbcDialect;
import org.gridgain.cache.store.jdbc.dialect.MySqlDialect;
import org.gridgain.cache.store.jdbc.dialect.OracleDialect;
import org.gridgain.cache.store.jdbc.dialect.PostgresqlDialect;
import org.gridgain.cache.store.jdbc.dialect.SqlServerDialect;
import org.jetbrains.annotations.Nullable;

public abstract class JdbcCacheStore<K, V>
implements CacheStore<K, V> {
    static final Collection<String> BUILT_IN_TYPES = new HashSet<String>();
    private final IgniteLogger log = Loggers.forClass(this.getClass());
    private volatile DataSource dataSrc;
    EntryMapping mapping;
    private int batchSize;
    protected JdbcDialect dialect;
    private int maxWrtAttempts;
    private int parallelLoadCacheMinThreshold;
    private JdbcType type;
    JdbcTypesTransformer transformer = JdbcTypesDefaultTransformer.INSTANCE;
    private boolean sqlEscapeAll;
    private ExecutorService executor;

    public CacheStoreSession beginSession() {
        JdbcCacheStoreSession ses = new JdbcCacheStoreSession();
        return ses;
    }

    @Nullable
    protected abstract Object extractParameter(String var1, TypeKind var2, String var3, Object var4) throws IgniteException;

    protected abstract <R> R buildObject(String var1, TypeKind var2, JdbcTypeField[] var3, Map<String, Integer> var4, ResultSet var5) throws IgniteException;

    protected abstract void prepareBuilders(JdbcType var1) throws IgniteException;

    private JdbcDialect resolveDialect() throws IgniteException {
        String dbProductName;
        Connection conn = null;
        try {
            conn = this.openConnection(false);
            dbProductName = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new JdbcCacheStoreConfigurationException("Failed access to metadata for detect database dialect.", e);
        }
        finally {
            IgniteUtils.closeQuiet((AutoCloseable)conn);
        }
        if ("H2".equals(dbProductName)) {
            return new H2Dialect();
        }
        if ("MySQL".equals(dbProductName)) {
            return new MySqlDialect();
        }
        if ("PostgreSQL".equals(dbProductName)) {
            return new PostgresqlDialect();
        }
        if (dbProductName.startsWith("Microsoft SQL Server")) {
            return new SqlServerDialect();
        }
        if ("Oracle".equals(dbProductName)) {
            return new OracleDialect();
        }
        if (dbProductName.startsWith("DB2/")) {
            return new Db2Dialect();
        }
        this.log.warn("Failed to resolve dialect (BasicJdbcDialect will be used): " + dbProductName, new Object[0]);
        return new BasicJdbcDialect();
    }

    void init() {
        String keyType = this.type.getKeyType();
        String valType = this.type.getValueType();
        TypeKind keyKind = this.kindForName(keyType);
        this.checkTypeConfiguration(keyKind, keyType, this.type.getKeyFields());
        TypeKind valKind = this.kindForName(valType);
        this.checkTypeConfiguration(valKind, valType, this.type.getValueFields());
        this.mapping = new EntryMapping(this.dialect, this.type, keyKind, valKind, this.sqlEscapeAll);
        this.prepareBuilders(this.type);
    }

    protected abstract TypeKind kindForName(String var1);

    void validate() throws IgniteException {
        if (this.dataSrc == null) {
            throw new JdbcCacheStoreConfigurationException("Failed to initialize cache store (data source is not provided).");
        }
        if (this.dialect == null) {
            this.dialect = this.resolveDialect();
            if (this.log.isDebugEnabled() && this.dialect.getClass() != BasicJdbcDialect.class) {
                this.log.debug("Resolved database dialect: " + this.dialect.getClass().getSimpleName(), new Object[0]);
            }
        }
    }

    Connection openConnection(boolean autocommit) throws SQLException {
        Connection conn = this.dataSrc.getConnection();
        conn.setAutoCommit(autocommit);
        return conn;
    }

    private Connection getOrCreateConnection(CacheStoreSession ses) throws SQLException {
        JdbcCacheStoreSession ses0 = (JdbcCacheStoreSession)ses;
        Connection conn = ses0.getConnection(this);
        if (conn == null) {
            conn = this.openConnection(false);
            ses0.setConnection(this, conn);
        }
        return conn;
    }

    private static void end(@Nullable Connection conn, @Nullable Statement st) {
        IgniteUtils.closeQuiet((AutoCloseable)st);
        IgniteUtils.closeQuiet((AutoCloseable)conn);
    }

    CompletableFuture<Void> sessionEnd(boolean commit, JdbcCacheStoreSession ses) throws IgniteException {
        return CompletableFuture.supplyAsync(() -> {
            InternalTransaction tx = (InternalTransaction)ses.getTransaction();
            Connection conn = ses.getConnection(this);
            if (conn == null) {
                return null;
            }
            try {
                if (commit) {
                    conn.commit();
                } else {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                throw new JdbcCacheStoreAccessException("Failed to end transaction [xid=" + tx.id() + ", commit=" + commit + "]", e);
            }
            finally {
                IgniteUtils.closeQuiet((AutoCloseable)conn);
            }
            return null;
        }, this.executor);
    }

    private CompletableFuture<Void> loadCacheRange(EntryMapping em, BiConsumer<K, V> clo, @Nullable Object[] lowerBound, @Nullable Object[] upperBound, int fetchSize) {
        return CompletableFuture.supplyAsync(() -> {
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                int j;
                int i;
                conn = this.openConnection(true);
                stmt = conn.prepareStatement(lowerBound == null && upperBound == null ? em.loadCacheQry : em.loadCacheRangeQuery(lowerBound != null, upperBound != null));
                stmt.setFetchSize(fetchSize);
                int idx = 1;
                if (lowerBound != null) {
                    for (i = lowerBound.length; i > 0; --i) {
                        for (j = 0; j < i; ++j) {
                            stmt.setObject(idx++, lowerBound[j]);
                        }
                    }
                }
                if (upperBound != null) {
                    for (i = upperBound.length; i > 0; --i) {
                        for (j = 0; j < i; ++j) {
                            stmt.setObject(idx++, upperBound[j]);
                        }
                    }
                }
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    Object key = this.buildObject(em.keyType(), em.keyKind(), em.keyColumns(), em.loadColIdxs, rs);
                    Object val = this.buildObject(em.valueType(), em.valueKind(), em.valueColumns(), em.loadColIdxs, rs);
                    clo.accept(key, val);
                }
            }
            catch (SQLException e) {
                try {
                    throw new JdbcCacheStoreAccessException("Failed to load cache", e);
                }
                catch (Throwable throwable) {
                    JdbcCacheStore.end(conn, stmt);
                    throw throwable;
                }
            }
            JdbcCacheStore.end(conn, stmt);
            return null;
        }, this.executor);
    }

    private CompletableFuture<Void> loadCacheFull(EntryMapping m, BiConsumer<K, V> clo) {
        return this.loadCacheRange(m, clo, null, null, this.dialect.getFetchSize());
    }

    private void checkTypeConfiguration(TypeKind kind, String typeName, JdbcTypeField[] flds) throws IgniteException {
        try {
            if (kind == TypeKind.BUILT_IN) {
                if (flds.length != 1) {
                    throw new JdbcCacheStoreConfigurationException("More than one field for built in type [tableName=" + this.mapping.fullTableName() + ", type=" + typeName + " ]");
                }
                JdbcTypeField field = flds[0];
                if (field.getDatabaseFieldName() == null) {
                    throw new JdbcCacheStoreConfigurationException("Missing database name in mapping description [tableName=" + this.mapping.fullTableName() + ", type=" + typeName + " ]");
                }
                field.setJavaFieldType(Class.forName(typeName));
            } else {
                for (JdbcTypeField field : flds) {
                    if (field.getDatabaseFieldName() == null) {
                        throw new JdbcCacheStoreConfigurationException("Missing database name in mapping description [tableName=" + this.mapping.fullTableName() + ", type=" + typeName + " ]");
                    }
                    if (field.getJavaFieldName() == null) {
                        throw new JdbcCacheStoreConfigurationException("Missing field name in mapping description [tableName=" + this.mapping.fullTableName() + ", type=" + typeName + " ]");
                    }
                    if (field.getJavaFieldType() != null) continue;
                    throw new JdbcCacheStoreConfigurationException("Missing field type in mapping description [tableName=" + this.mapping.fullTableName() + ", type=" + typeName + " ]");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new JdbcCacheStoreConfigurationException("Failed to find class: " + typeName, e);
        }
    }

    protected static Integer columnIndex(Map<String, Integer> loadColIdxs, String dbName) {
        Integer colIdx = loadColIdxs.get(dbName.toUpperCase());
        if (colIdx == null) {
            throw new JdbcCacheStoreConfigurationException("Failed to find column index for database field: " + dbName);
        }
        return colIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> loadCacheAsync(BiConsumer<K, V> clo, Object ... args) {
        ArrayList<CompletableFuture<Void>> futs;
        block18: {
            String keyType;
            block20: {
                PreparedStatement stmt;
                Connection conn;
                block17: {
                    int fetchSz;
                    block19: {
                        fetchSz = this.dialect.getFetchSize();
                        futs = new ArrayList<CompletableFuture<Void>>();
                        if (args == null || args.length <= 0) break block19;
                        if (args.length % 2 != 0) {
                            throw new JdbcCacheStoreAccessException("Expected even number of arguments, but found: " + args.length);
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Start loading entries from db using user queries from arguments...", new Object[0]);
                        }
                        for (int i = 0; i < args.length; i += 2) {
                            LoadCacheCustomQueryWorker<K, V> task;
                            Objects.requireNonNull(args[i]);
                            String keyType2 = args[i].toString();
                            Object arg = args[i + 1];
                            Objects.requireNonNull(arg);
                            if (arg instanceof PreparedStatement) {
                                PreparedStatement stmt2 = (PreparedStatement)arg;
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("Started load cache using custom statement [table=" + this.mapping.fullTableName() + ", keyType=" + keyType2 + ", stmt=" + stmt2 + "]", new Object[0]);
                                }
                                task = new LoadCacheCustomQueryWorker<K, V>(this.mapping, stmt2, clo);
                            } else {
                                String qry = arg.toString();
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("Started load cache using custom query [table=" + this.mapping.fullTableName() + ", keyType=" + keyType2 + ", query=" + qry + "]", new Object[0]);
                                }
                                task = new LoadCacheCustomQueryWorker<K, V>(this.mapping, qry, clo);
                            }
                            futs.add(CompletableFuture.supplyAsync(task, this.executor));
                        }
                        break block18;
                    }
                    keyType = this.mapping.keyType();
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Started load cache [table=" + this.mapping.fullTableName() + ", keyType=" + keyType + "]", new Object[0]);
                    }
                    if (this.parallelLoadCacheMinThreshold <= 0) break block20;
                    conn = null;
                    stmt = null;
                    try {
                        conn = this.openConnection(true);
                        stmt = conn.prepareStatement(this.mapping.loadCacheSelRangeQry);
                        stmt.setInt(1, this.parallelLoadCacheMinThreshold);
                        ResultSet rs = stmt.executeQuery();
                        if (!rs.next()) break block17;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Multithread loading entries from db [table=" + this.mapping.fullTableName() + ", keyType=" + keyType + "]", new Object[0]);
                        }
                        int keyCnt = this.mapping.keyCols.size();
                        Object[] upperBound = new Object[keyCnt];
                        for (int i = 0; i < keyCnt; ++i) {
                            upperBound[i] = rs.getObject(i + 1);
                        }
                        futs.add(this.loadCacheRange(this.mapping, clo, null, upperBound, fetchSz));
                        while (rs.next()) {
                            Object[] lowerBound = upperBound;
                            upperBound = new Object[keyCnt];
                            for (int i = 0; i < keyCnt; ++i) {
                                upperBound[i] = rs.getObject(i + 1);
                            }
                            futs.add(this.loadCacheRange(this.mapping, clo, lowerBound, upperBound, fetchSz));
                        }
                        futs.add(this.loadCacheRange(this.mapping, clo, upperBound, null, fetchSz));
                    }
                    catch (SQLException e) {
                        try {
                            this.log.warn("Failed to load entries from db in multithreaded mode, will try in single thread [tableName=" + this.mapping.fullTableName() + ", keyType=" + keyType + "]", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            JdbcCacheStore.end(conn, stmt);
                            throw throwable;
                        }
                        JdbcCacheStore.end(conn, stmt);
                        break block18;
                    }
                }
                JdbcCacheStore.end(conn, stmt);
                break block18;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Single thread loading entries from db [table=" + this.mapping.fullTableName() + ", keyType=" + keyType + "]", new Object[0]);
            }
            futs.add(this.loadCacheFull(this.mapping, clo));
        }
        return CompletableFuture.allOf(futs.toArray(new CompletableFuture[0])).thenApply(unused -> {
            if (this.log.isInfoEnabled()) {
                this.log.info("Finished load cache from table: " + this.mapping.fullTableName(), new Object[0]);
            }
            return null;
        });
    }

    public CompletableFuture<V> loadAsync(K key) {
        assert (key != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Load value from db [table= " + this.mapping.fullTableName() + ", key=" + key + "]", new Object[0]);
        }
        return CompletableFuture.supplyAsync(() -> {
            PreparedStatement stmt;
            Connection conn;
            block4: {
                Object r;
                conn = null;
                stmt = null;
                try {
                    conn = this.openConnection(true);
                    stmt = conn.prepareStatement(this.mapping.loadQrySingle);
                    this.fillKeyParameters(stmt, this.mapping, key);
                    ResultSet rs = stmt.executeQuery();
                    if (!rs.next()) break block4;
                    r = this.buildObject(this.mapping.valueType(), this.mapping.valueKind(), this.mapping.valueColumns(), this.mapping.loadColIdxs, rs);
                }
                catch (Exception e) {
                    try {
                        throw new JdbcCacheStoreAccessException("Failed to load object [table=" + this.mapping.fullTableName() + ", key=" + key + "]", e);
                    }
                    catch (Throwable throwable) {
                        JdbcCacheStore.end(conn, stmt);
                        throw throwable;
                    }
                }
                JdbcCacheStore.end(conn, stmt);
                return r;
            }
            JdbcCacheStore.end(conn, stmt);
            return null;
        }, this.executor);
    }

    public CompletableFuture<Map<K, V>> loadAllAsync(Iterable<? extends K> keys) {
        assert (keys != null);
        return CompletableFuture.supplyAsync(() -> {
            Connection conn = null;
            try {
                conn = this.openConnection(true);
                HashMap res = new HashMap();
                LoadWorker worker = new LoadWorker(conn, this.mapping);
                for (Object key : keys) {
                    worker.keys.add(key);
                    if (worker.keys.size() != this.mapping.maxKeysPerStmt) continue;
                    res.putAll(worker.call());
                    worker = new LoadWorker(conn, this.mapping);
                }
                if (!worker.keys.isEmpty()) {
                    res.putAll(worker.call());
                }
                HashMap hashMap = res;
                return hashMap;
            }
            catch (Exception e) {
                throw new JdbcCacheStoreAccessException("Failed to load entries from database", e);
            }
            finally {
                JdbcCacheStore.closeQuiet(conn);
            }
        }, this.executor);
    }

    private void writeUpsert(PreparedStatement insStmt, PreparedStatement updStmt, EntryMapping em, Map.Entry<? extends K, ? extends V> entry) throws IgniteException {
        try {
            JdbcCacheStoreAccessException we = null;
            for (int attempt = 0; attempt < this.maxWrtAttempts; ++attempt) {
                int paramIdx = this.fillValueParameters(updStmt, 1, em, entry.getValue());
                this.fillKeyParameters(updStmt, paramIdx, em, entry.getKey());
                if (updStmt.executeUpdate() == 0) {
                    paramIdx = this.fillKeyParameters(insStmt, em, entry.getKey());
                    this.fillValueParameters(insStmt, paramIdx, em, entry.getValue());
                    try {
                        insStmt.executeUpdate();
                        if (attempt > 0) {
                            this.log.warn("Entry was inserted in database on second try [table=" + em.fullTableName() + ", entry=" + entry + "]", new Object[0]);
                        }
                    }
                    catch (SQLException e) {
                        String sqlState = e.getSQLState();
                        for (SQLException nested = e.getNextException(); sqlState == null && nested != null; nested = nested.getNextException()) {
                            sqlState = nested.getSQLState();
                        }
                        if ("23505".equals(sqlState) || "23000".equals(sqlState)) {
                            if (we == null) {
                                we = new JdbcCacheStoreAccessException("Failed insert entry in database, violate a unique index or primary key [table=" + em.fullTableName() + ", entry=" + entry + "]");
                            }
                            we.addSuppressed(e);
                            this.log.warn("Failed insert entry in database, violate a unique index or primary key [table=" + em.fullTableName() + ", entry=" + entry + "]", new Object[0]);
                            continue;
                        }
                        throw new JdbcCacheStoreAccessException("Failed insert entry in database [table=" + em.fullTableName() + ", entry=" + entry, e);
                    }
                }
                if (attempt > 0) {
                    this.log.warn("Entry was updated in database on second try [table=" + em.fullTableName() + ", entry=" + entry + "]", new Object[0]);
                }
                return;
            }
            throw we;
        }
        catch (SQLException e) {
            throw new JdbcCacheStoreAccessException("Failed update entry in database [table=" + em.fullTableName() + ", entry=" + entry + "]", e);
        }
    }

    public CompletableFuture<Void> writeAsync(CacheStoreSession session, Map.Entry<? extends K, ? extends V> entry) {
        assert (entry != null);
        K key = entry.getKey();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start write entry to database [table=" + this.mapping.fullTableName() + ", entry=" + entry + "]", new Object[0]);
        }
        return CompletableFuture.supplyAsync(() -> {
            block8: {
                try {
                    Connection conn = this.getOrCreateConnection(session);
                    if (this.dialect.hasMerge()) {
                        PreparedStatement stmt;
                        block7: {
                            stmt = null;
                            try {
                                stmt = conn.prepareStatement(this.mapping.mergeQry);
                                int idx = this.fillKeyParameters(stmt, this.mapping, key);
                                this.fillValueParameters(stmt, idx, this.mapping, entry.getValue());
                                int updCnt = stmt.executeUpdate();
                                if (updCnt == 1) break block7;
                                this.log.warn("Unexpected number of updated entries [table=" + this.mapping.fullTableName() + ", entry=" + entry + "expected=1, actual=" + updCnt + "]", new Object[0]);
                            }
                            catch (Throwable throwable) {
                                IgniteUtils.closeQuiet(stmt);
                                throw throwable;
                            }
                        }
                        IgniteUtils.closeQuiet((AutoCloseable)stmt);
                        break block8;
                    }
                    PreparedStatement insStmt = null;
                    PreparedStatement updStmt = null;
                    try {
                        insStmt = conn.prepareStatement(this.mapping.insQry);
                        updStmt = conn.prepareStatement(this.mapping.updQry);
                        this.writeUpsert(insStmt, updStmt, this.mapping, entry);
                    }
                    catch (Throwable throwable) {
                        IgniteUtils.closeQuiet(insStmt);
                        IgniteUtils.closeQuiet(updStmt);
                        throw throwable;
                    }
                    IgniteUtils.closeQuiet((AutoCloseable)insStmt);
                    IgniteUtils.closeQuiet((AutoCloseable)updStmt);
                }
                catch (SQLException e) {
                    throw new JdbcCacheStoreAccessException("Failed to write entry to database [table=" + this.mapping.fullTableName() + ", entry=" + entry + "]", e);
                }
            }
            return null;
        }, this.executor);
    }

    public CompletableFuture<Void> writeAllAsync(CacheStoreSession session, final Collection<Map.Entry<? extends K, ? extends V>> entries) {
        assert (entries != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Start write entries to database [table=" + this.mapping.fullTableName() + ", entries=" + entries + "]", new Object[0]);
        }
        return CompletableFuture.supplyAsync(() -> {
            block15: {
                try {
                    Connection conn = this.getOrCreateConnection(session);
                    if (this.dialect.hasMerge()) {
                        PreparedStatement mergeStmt = conn.prepareStatement(this.mapping.mergeQry);
                        try {
                            LazyValue<Object[]> lazyEntries = new LazyValue<Object[]>(){

                                @Override
                                public Object[] create() {
                                    return entries.toArray();
                                }
                            };
                            int fromIdx = 0;
                            int prepared = 0;
                            for (Map.Entry entry : entries) {
                                Object key = entry.getKey();
                                int idx = this.fillKeyParameters(mergeStmt, this.mapping, key);
                                this.fillValueParameters(mergeStmt, idx, this.mapping, entry.getValue());
                                mergeStmt.addBatch();
                                if (++prepared % this.batchSize != 0) continue;
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Write entries to db [table=" + this.mapping.fullTableName() + ", keyType=" + this.mapping.keyType() + ", cnt=" + prepared + "]", new Object[0]);
                                }
                                this.executeBatch(this.mapping, mergeStmt, "writeAll", fromIdx, prepared, lazyEntries);
                                fromIdx += prepared;
                                prepared = 0;
                            }
                            if (mergeStmt != null && prepared % this.batchSize != 0) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Write entries to db [table=" + this.mapping.fullTableName() + ", keyType=" + this.mapping.keyType() + ", cnt=" + prepared + "]", new Object[0]);
                                }
                                this.executeBatch(this.mapping, mergeStmt, "writeAll", fromIdx, prepared, lazyEntries);
                            }
                            break block15;
                        }
                        finally {
                            IgniteUtils.closeQuiet((AutoCloseable)mergeStmt);
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Write entries to db one by one using update and insert statements [table=" + this.mapping.fullTableName() + ", cnt=" + entries.size() + "]", new Object[0]);
                    }
                    PreparedStatement insStmt = conn.prepareStatement(this.mapping.insQry);
                    PreparedStatement updStmt = conn.prepareStatement(this.mapping.updQry);
                    try {
                        for (Map.Entry entry : entries) {
                            this.writeUpsert(insStmt, updStmt, this.mapping, entry);
                        }
                    }
                    finally {
                        IgniteUtils.closeQuiet((AutoCloseable)insStmt);
                        IgniteUtils.closeQuiet((AutoCloseable)updStmt);
                    }
                }
                catch (SQLException e) {
                    throw new JdbcCacheStoreAccessException("Failed to write entries in database", e);
                }
            }
            return null;
        }, this.executor);
    }

    public CompletableFuture<Void> deleteAsync(CacheStoreSession session, K key) {
        assert (key != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove value from db [table=" + this.mapping.fullTableName() + ", key=" + key + "]", new Object[0]);
        }
        return CompletableFuture.supplyAsync(() -> {
            PreparedStatement stmt = null;
            try {
                Connection conn = this.getOrCreateConnection(session);
                stmt = conn.prepareStatement(this.mapping.remQry);
                this.fillKeyParameters(stmt, this.mapping, key);
                int delCnt = stmt.executeUpdate();
                if (delCnt != 1) {
                    this.log.warn("Unexpected number of deleted entries [table=" + this.mapping.fullTableName() + ", key=" + key + ", expected=1, actual=" + delCnt + "]", new Object[0]);
                }
            }
            catch (SQLException e) {
                try {
                    throw new JdbcCacheStoreAccessException("Failed to remove value from database [table=" + this.mapping.fullTableName() + ", key=" + key + "]", e);
                }
                catch (Throwable throwable) {
                    IgniteUtils.closeQuiet(stmt);
                    throw throwable;
                }
            }
            IgniteUtils.closeQuiet((AutoCloseable)stmt);
            return null;
        }, this.executor);
    }

    public CompletableFuture<Void> deleteAllAsync(CacheStoreSession session, final Collection<? extends K> keys) {
        assert (keys != null);
        return CompletableFuture.supplyAsync(() -> {
            PreparedStatement delStmt = null;
            try {
                Connection conn = this.getOrCreateConnection(session);
                LazyValue<Object[]> lazyKeys = new LazyValue<Object[]>(){

                    @Override
                    public Object[] create() {
                        return keys.toArray();
                    }
                };
                delStmt = conn.prepareStatement(this.mapping.remQry);
                int fromIdx = 0;
                int prepared = 0;
                for (Object key : keys) {
                    this.fillKeyParameters(delStmt, this.mapping, key);
                    delStmt.addBatch();
                    if (++prepared % this.batchSize != 0) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Delete entries from db [table=" + this.mapping.fullTableName() + ", keyType=" + this.mapping.keyType() + ", cnt=" + prepared + "]", new Object[0]);
                    }
                    this.executeBatch(this.mapping, delStmt, "deleteAll", fromIdx, prepared, lazyKeys);
                    fromIdx += prepared;
                    prepared = 0;
                }
                if (prepared % this.batchSize != 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Delete entries from db [table=" + this.mapping.fullTableName() + ", keyType=" + this.mapping.keyType() + ", cnt=" + prepared + "]", new Object[0]);
                    }
                    this.executeBatch(this.mapping, delStmt, "deleteAll", fromIdx, prepared, lazyKeys);
                }
            }
            catch (SQLException e) {
                try {
                    throw new JdbcCacheStoreAccessException("Failed to remove values from database", e);
                }
                catch (Throwable throwable) {
                    IgniteUtils.closeQuiet(delStmt);
                    throw throwable;
                }
            }
            IgniteUtils.closeQuiet((AutoCloseable)delStmt);
            return null;
        }, this.executor);
    }

    private void executeBatch(EntryMapping em, Statement stmt, String desc, int fromIdx, int prepared, LazyValue<Object[]> lazyObjs) throws SQLException {
        try {
            int[] rowCounts = stmt.executeBatch();
            int numOfRowCnt = rowCounts.length;
            if (numOfRowCnt != prepared) {
                this.log.warn("Unexpected number of updated rows [table=" + em.fullTableName() + ", expected=" + prepared + ", actual=" + numOfRowCnt + "]", new Object[0]);
            }
            for (int i = 0; i < numOfRowCnt; ++i) {
                int cnt = rowCounts[i];
                if (cnt == 1 || cnt == -2) continue;
                Object[] objs = lazyObjs.value();
                this.log.warn("Batch " + desc + " returned unexpected updated row count [table=" + em.fullTableName() + ", entry=" + objs[fromIdx + i] + ", expected=1, actual=" + cnt + "]", new Object[0]);
            }
        }
        catch (BatchUpdateException be) {
            int[] rowCounts = be.getUpdateCounts();
            for (int i = 0; i < rowCounts.length; ++i) {
                if (rowCounts[i] != -3) continue;
                Object[] objs = lazyObjs.value();
                this.log.warn("Batch " + desc + " failed on execution [table=" + em.fullTableName() + ", entry=" + objs[fromIdx + i] + "]", new Object[0]);
            }
            throw be;
        }
    }

    protected static void fillParameter(PreparedStatement stmt, int idx, JdbcTypeField field, @Nullable Object fieldVal) {
        block9: {
            try {
                block10: {
                    block12: {
                        block11: {
                            if (fieldVal == null) break block10;
                            if (field.getJavaFieldType() != UUID.class) break block11;
                            switch (field.getDatabaseFieldType()) {
                                case -2: {
                                    ByteBuffer buf = ByteBuffer.allocate(16);
                                    buf.order(ByteOrder.BIG_ENDIAN);
                                    UUID uuid = (UUID)fieldVal;
                                    buf.putLong(uuid.getMostSignificantBits());
                                    buf.putLong(uuid.getLeastSignificantBits());
                                    fieldVal = buf.array();
                                    break block12;
                                }
                                case 1: 
                                case 12: {
                                    fieldVal = fieldVal.toString();
                                    break block12;
                                }
                                default: {
                                    throw new JdbcCacheStoreConfigurationException("Incompatible column type for UUID: " + field.getDatabaseFieldName());
                                }
                            }
                        }
                        if (field.getJavaFieldType().isEnum()) {
                            if (fieldVal instanceof Enum) {
                                Enum val = (Enum)fieldVal;
                                fieldVal = JdbcTypesTransformer.NUMERIC_TYPES.contains(field.getDatabaseFieldType()) ? Integer.valueOf(val.ordinal()) : val.name();
                            } else {
                                throw new JdbcCacheStoreConfigurationException("Expecting enum type: " + field.getDatabaseFieldName());
                            }
                        }
                    }
                    stmt.setObject(idx, fieldVal);
                    break block9;
                }
                stmt.setNull(idx, field.getDatabaseFieldType());
            }
            catch (SQLException e) {
                throw new JdbcCacheStoreConfigurationException("Failed to set statement parameter name: " + field.getDatabaseFieldName(), e);
            }
        }
    }

    protected int fillKeyParameters(PreparedStatement stmt, int idx, EntryMapping em, Object key) throws IgniteException {
        for (JdbcTypeField field : em.keyColumns()) {
            Object fieldVal = this.extractParameter(em.keyType(), em.keyKind(), field.getJavaFieldName(), key);
            JdbcCacheStore.fillParameter(stmt, idx++, field, fieldVal);
        }
        return idx;
    }

    protected int fillKeyParameters(PreparedStatement stmt, EntryMapping m, Object key) throws IgniteException {
        return this.fillKeyParameters(stmt, 1, m, key);
    }

    protected int fillValueParameters(PreparedStatement stmt, int idx, EntryMapping em, Object val) throws IgniteException {
        for (JdbcTypeField field : em.uniqValFlds) {
            Object fieldVal = this.extractParameter(em.valueType(), em.valueKind(), field.getJavaFieldName(), val);
            JdbcCacheStore.fillParameter(stmt, idx++, field, fieldVal);
        }
        return idx;
    }

    public DataSource getDataSource() {
        return this.dataSrc;
    }

    public void setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
    }

    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(JdbcDialect dialect) {
        this.dialect = dialect;
    }

    public int getMaximumWriteAttempts() {
        return this.maxWrtAttempts;
    }

    public void setMaximumWriteAttempts(int maxWrtAttempts) {
        this.maxWrtAttempts = maxWrtAttempts;
    }

    public JdbcType getType() {
        return this.type;
    }

    public void setType(JdbcType type) {
        this.type = type;
    }

    public JdbcTypesTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(JdbcTypesTransformer transformer) {
        this.transformer = transformer;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getParallelLoadCacheMinimumThreshold() {
        return this.parallelLoadCacheMinThreshold;
    }

    public void setParallelLoadCacheMinimumThreshold(int parallelLoadCacheMinThreshold) {
        this.parallelLoadCacheMinThreshold = parallelLoadCacheMinThreshold;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public boolean isSqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public void setSqlEscapeAll(boolean sqlEscapeAll) {
        this.sqlEscapeAll = sqlEscapeAll;
    }

    private static void closeQuiet(@Nullable Object obj) {
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        BUILT_IN_TYPES.add("java.math.BigDecimal");
        BUILT_IN_TYPES.add("java.lang.Boolean");
        BUILT_IN_TYPES.add("java.lang.Byte");
        BUILT_IN_TYPES.add("java.lang.Character");
        BUILT_IN_TYPES.add("java.lang.Double");
        BUILT_IN_TYPES.add("java.util.Date");
        BUILT_IN_TYPES.add("java.sql.Date");
        BUILT_IN_TYPES.add("java.lang.Float");
        BUILT_IN_TYPES.add("java.lang.Integer");
        BUILT_IN_TYPES.add("java.lang.Long");
        BUILT_IN_TYPES.add("java.lang.Short");
        BUILT_IN_TYPES.add("java.lang.String");
        BUILT_IN_TYPES.add("java.sql.Timestamp");
        BUILT_IN_TYPES.add("java.util.UUID");
    }

    protected static enum TypeKind {
        BUILT_IN,
        POJO,
        TUPLE;

    }

    protected static class EntryMapping {
        private final JdbcDialect dialect;
        private final String loadCacheSelRangeQry;
        private final String loadCacheQry;
        private final String loadQrySingle;
        private final String loadQry;
        private final String mergeQry;
        private final String insQry;
        private final String updQry;
        private final String remQry;
        private final int maxKeysPerStmt;
        private final Collection<String> keyCols;
        private final Collection<String> sqlKeyCols;
        private final Collection<String> cols;
        private final Collection<String> sqlCols;
        private final Map<String, Integer> loadColIdxs;
        private final Collection<JdbcTypeField> uniqValFlds;
        private final JdbcType typeMeta;
        private final TypeKind keyKind;
        private final TypeKind valKind;
        private final String fullTblName;
        private final String sqlFullTblName;

        private static Collection<String> escape(JdbcDialect dialect, Collection<String> cols) {
            ArrayList<String> res = new ArrayList<String>(cols.size());
            for (String col : cols) {
                res.add(dialect.escape(col));
            }
            return res;
        }

        public EntryMapping(JdbcDialect dialect, JdbcType typeMeta, TypeKind keyKind, TypeKind valKind, boolean escape) {
            Collection<String> sqlUniqueValCols;
            this.dialect = dialect;
            this.typeMeta = typeMeta;
            this.keyKind = keyKind;
            this.valKind = valKind;
            JdbcTypeField[] keyFields = typeMeta.getKeyFields();
            JdbcTypeField[] valFields = typeMeta.getValueFields();
            this.keyCols = EntryMapping.databaseColumns(Arrays.asList(keyFields));
            this.uniqValFlds = Arrays.stream(valFields).filter(col -> !this.keyCols.contains(col.getDatabaseFieldName())).collect(Collectors.toList());
            String schema = typeMeta.getDatabaseSchema();
            String tblName = typeMeta.getDatabaseTable();
            Collection<String> uniqueValCols = EntryMapping.databaseColumns(this.uniqValFlds);
            this.cols = Stream.concat(this.keyCols.stream(), uniqueValCols.stream()).collect(Collectors.toList());
            this.loadColIdxs = IgniteUtils.newHashMap((int)this.cols.size());
            int idx = 1;
            for (String col2 : this.cols) {
                this.loadColIdxs.put(col2.toUpperCase(), idx++);
            }
            String string = this.fullTblName = StringUtils.nullOrEmpty((String)schema) ? tblName : schema + "." + tblName;
            if (escape) {
                this.sqlFullTblName = StringUtils.nullOrEmpty((String)schema) ? dialect.escape(tblName) : dialect.escape(schema) + "." + dialect.escape(tblName);
                this.sqlCols = EntryMapping.escape(dialect, this.cols);
                this.sqlKeyCols = EntryMapping.escape(dialect, this.keyCols);
                sqlUniqueValCols = EntryMapping.escape(dialect, uniqueValCols);
            } else {
                this.sqlFullTblName = this.fullTblName;
                this.sqlCols = this.cols;
                this.sqlKeyCols = this.keyCols;
                sqlUniqueValCols = uniqueValCols;
            }
            this.loadCacheQry = dialect.loadCacheQuery(this.sqlFullTblName, this.sqlCols);
            this.loadCacheSelRangeQry = dialect.loadCacheSelectRangeQuery(this.sqlFullTblName, this.sqlKeyCols);
            this.loadQrySingle = dialect.loadQuery(this.sqlFullTblName, this.sqlKeyCols, this.sqlCols, 1);
            this.maxKeysPerStmt = dialect.getMaxParameterCount() / this.sqlKeyCols.size();
            this.loadQry = dialect.loadQuery(this.sqlFullTblName, this.sqlKeyCols, this.sqlCols, this.maxKeysPerStmt);
            this.insQry = dialect.insertQuery(this.sqlFullTblName, this.sqlKeyCols, sqlUniqueValCols);
            this.updQry = dialect.updateQuery(this.sqlFullTblName, this.sqlKeyCols, sqlUniqueValCols);
            this.mergeQry = dialect.mergeQuery(this.sqlFullTblName, this.sqlKeyCols, sqlUniqueValCols);
            this.remQry = dialect.removeQuery(this.sqlFullTblName, this.sqlKeyCols);
        }

        private static Collection<String> databaseColumns(Collection<JdbcTypeField> dsc) {
            return dsc.stream().map(JdbcTypeField::getDatabaseFieldName).collect(Collectors.toList());
        }

        protected String keyType() {
            return this.typeMeta.getKeyType();
        }

        protected TypeKind keyKind() {
            return this.keyKind;
        }

        protected String valueType() {
            return this.typeMeta.getValueType();
        }

        protected TypeKind valueKind() {
            return this.valKind;
        }

        protected String loadQuery(int keyCnt) {
            assert (keyCnt <= this.maxKeysPerStmt);
            if (keyCnt == this.maxKeysPerStmt) {
                return this.loadQry;
            }
            if (keyCnt == 1) {
                return this.loadQrySingle;
            }
            return this.dialect.loadQuery(this.sqlFullTblName, this.sqlKeyCols, this.sqlCols, keyCnt);
        }

        protected String loadCacheRangeQuery(boolean appendLowerBound, boolean appendUpperBound) {
            return this.dialect.loadCacheRangeQuery(this.sqlFullTblName, this.sqlKeyCols, this.sqlCols, appendLowerBound, appendUpperBound);
        }

        protected JdbcTypeField[] keyColumns() {
            return this.typeMeta.getKeyFields();
        }

        protected JdbcTypeField[] valueColumns() {
            return this.typeMeta.getValueFields();
        }

        protected String fullTableName() {
            return this.fullTblName;
        }
    }

    private class LoadCacheCustomQueryWorker<K1, V1>
    implements Supplier<Void> {
        private final EntryMapping em;
        private PreparedStatement stmt;
        private String qry;
        private final BiConsumer<K1, V1> clo;

        private LoadCacheCustomQueryWorker(EntryMapping em, PreparedStatement stmt, BiConsumer<K1, V1> clo) {
            this.em = em;
            this.stmt = stmt;
            this.clo = clo;
        }

        private LoadCacheCustomQueryWorker(EntryMapping em, String qry, BiConsumer<K1, V1> clo) {
            this.em = em;
            this.qry = qry;
            this.clo = clo;
        }

        @Override
        public Void get() {
            Connection conn = null;
            try {
                if (this.stmt == null) {
                    conn = JdbcCacheStore.this.openConnection(true);
                    this.stmt = conn.prepareStatement(this.qry);
                }
                this.stmt.setFetchSize(JdbcCacheStore.this.dialect.getFetchSize());
                ResultSet rs = this.stmt.executeQuery();
                ResultSetMetaData meta = rs.getMetaData();
                HashMap colIdxs = IgniteUtils.newHashMap((int)meta.getColumnCount());
                for (int i = 1; i <= meta.getColumnCount(); ++i) {
                    colIdxs.put(meta.getColumnLabel(i).toUpperCase(), i);
                }
                while (rs.next()) {
                    Object key = JdbcCacheStore.this.buildObject(this.em.keyType(), this.em.keyKind(), this.em.keyColumns(), colIdxs, rs);
                    Object val = JdbcCacheStore.this.buildObject(this.em.valueType(), this.em.valueKind(), this.em.valueColumns(), colIdxs, rs);
                    this.clo.accept(key, val);
                }
                Void void_ = null;
                return void_;
            }
            catch (SQLException e) {
                throw new JdbcCacheStoreAccessException("Failed to execute custom query for load cache", e);
            }
            finally {
                if (conn != null) {
                    IgniteUtils.closeQuiet((AutoCloseable)this.stmt);
                    IgniteUtils.closeQuiet((AutoCloseable)conn);
                }
            }
        }
    }

    private static abstract class LazyValue<T> {
        private T val;

        private LazyValue() {
        }

        protected abstract T create();

        public T value() {
            if (this.val == null) {
                this.val = this.create();
            }
            return this.val;
        }
    }

    private class LoadWorker<K1, V1>
    implements Callable<Map<K1, V1>> {
        private final Connection conn;
        private final Collection<K1> keys;
        private final EntryMapping em;

        private LoadWorker(Connection conn, EntryMapping em) {
            this.conn = conn;
            this.em = em;
            this.keys = new ArrayList<K1>(em.maxKeysPerStmt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<K1, V1> call() throws Exception {
            HashMap hashMap;
            if (JdbcCacheStore.this.log.isDebugEnabled()) {
                JdbcCacheStore.this.log.debug("Load values from db [table= " + this.em.fullTableName() + ", keysCnt=" + this.keys.size() + "]", new Object[0]);
            }
            PreparedStatement stmt = null;
            try {
                stmt = this.conn.prepareStatement(this.em.loadQuery(this.keys.size()));
                int idx = 1;
                for (K1 key : this.keys) {
                    for (JdbcTypeField field : this.em.keyColumns()) {
                        Object fieldVal = JdbcCacheStore.this.extractParameter(this.em.keyType(), this.em.keyKind(), field.getJavaFieldName(), key);
                        JdbcCacheStore.fillParameter(stmt, idx++, field, fieldVal);
                    }
                }
                ResultSet rs = stmt.executeQuery();
                HashMap entries = IgniteUtils.newHashMap((int)this.keys.size());
                while (rs.next()) {
                    Object r = JdbcCacheStore.this.buildObject(this.em.keyType(), this.em.keyKind(), this.em.keyColumns(), this.em.loadColIdxs, rs);
                    Object val = JdbcCacheStore.this.buildObject(this.em.valueType(), this.em.valueKind(), this.em.valueColumns(), this.em.loadColIdxs, rs);
                    entries.put(r, val);
                }
                hashMap = entries;
            }
            catch (Throwable throwable) {
                IgniteUtils.closeQuiet(stmt);
                throw throwable;
            }
            IgniteUtils.closeQuiet((AutoCloseable)stmt);
            return hashMap;
        }
    }
}

