/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc.dialect;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gridgain.cache.store.jdbc.dialect.BasicJdbcDialect;

public class MySqlDialect
extends BasicJdbcDialect {
    public MySqlDialect() {
        this.fetchSize = Integer.MIN_VALUE;
    }

    @Override
    public String escape(String ident) {
        return "`" + ident + "`";
    }

    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = MySqlDialect.mkString(keyCols, ",");
        return String.format("SELECT %s FROM (SELECT %s, @rownum := @rownum + 1 AS rn FROM %s, (SELECT @rownum := 0) r ORDER BY %s) as r WHERE mod(rn, ?) = 0", cols, cols, fullTblName, cols);
    }

    @Override
    public boolean hasMerge() {
        return true;
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        Collection cols = Stream.concat(keyCols.stream(), uniqCols.stream()).collect(Collectors.toList());
        String updPart = MySqlDialect.mkString(uniqCols, col -> String.format("%s = VALUES(%s)", col, col), "", ", ", "");
        return String.format("INSERT INTO %s (%s) VALUES (%s) ON DUPLICATE KEY UPDATE %s", fullTblName, MySqlDialect.mkString(cols, ", "), MySqlDialect.repeat("?", cols.size(), "", ",", ""), updPart);
    }
}

