/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javax.sql.DataSource;
import org.apache.ignite.cache.CacheStore;
import org.apache.ignite.cache.CacheStoreFactory;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.table.Tuple;
import org.gridgain.cache.store.jdbc.JdbcCacheStore;
import org.gridgain.cache.store.jdbc.JdbcCacheStoreConfigurationException;
import org.gridgain.cache.store.jdbc.JdbcPojoCacheStore;
import org.gridgain.cache.store.jdbc.JdbcTupleCacheStore;
import org.gridgain.cache.store.jdbc.JdbcType;
import org.gridgain.cache.store.jdbc.JdbcTypesDefaultTransformer;
import org.gridgain.cache.store.jdbc.JdbcTypesTransformer;
import org.gridgain.cache.store.jdbc.dialect.JdbcDialect;

public class JdbcCacheStoreFactory
implements CacheStoreFactory {
    public static final int DFLT_WRITE_ATTEMPTS = 2;
    public static final int DFLT_BATCH_SIZE = 512;
    public static final int DFLT_PARALLEL_LOAD_CACHE_MINIMUM_THRESHOLD = 512;
    private int batchSize = 512;
    private JdbcDialect dialect;
    private ExecutorService executor = ForkJoinPool.commonPool();
    private int maxWrtAttempts = 2;
    private int parallelLoadCacheMinThreshold = 512;
    private JdbcTypesTransformer transformer = JdbcTypesDefaultTransformer.INSTANCE;
    private JdbcType type;
    private DataSource dataSrc;
    private boolean sqlEscapeAll;

    public <K, V> CacheStore<K, V> create(Class<K> keyCls, Class<V> valCls) {
        if (!this.type.getKeyType().equals(keyCls.getName())) {
            throw new JdbcCacheStoreConfigurationException(IgniteStringFormatter.format((String)"Failed to initialize cache store due to key type mismatch: [jdbcKeyType={}, providedKeyType={}].", (Object[])new Object[]{this.type.getKeyType(), keyCls.getName()}));
        }
        if (!this.type.getValueType().equals(valCls.getName())) {
            throw new JdbcCacheStoreConfigurationException(IgniteStringFormatter.format((String)"Failed to initialize cache store due to value type mismatch: [jdbcValueType={}, providedValueType={}].", (Object[])new Object[]{this.type.getValueType(), valCls.getName()}));
        }
        JdbcCacheStore store = keyCls.equals(Tuple.class) && valCls.equals(Tuple.class) ? new JdbcTupleCacheStore() : new JdbcPojoCacheStore();
        store.setExecutor(this.executor);
        store.setBatchSize(this.batchSize);
        store.setDialect(this.dialect);
        store.setMaximumWriteAttempts(this.maxWrtAttempts);
        store.setParallelLoadCacheMinimumThreshold(this.parallelLoadCacheMinThreshold);
        store.setType(this.type);
        store.setTransformer(this.transformer);
        store.setSqlEscapeAll(this.sqlEscapeAll);
        store.setDataSource(this.dataSrc);
        store.validate();
        store.init();
        return store;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public JdbcCacheStoreFactory setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSrc;
    }

    public JdbcCacheStoreFactory setDataSource(DataSource dataSrc) {
        this.dataSrc = dataSrc;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public JdbcCacheStoreFactory setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public JdbcCacheStoreFactory setDialect(JdbcDialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public int getMaximumWriteAttempts() {
        return this.maxWrtAttempts;
    }

    public JdbcCacheStoreFactory setMaximumWriteAttempts(int maxWrtAttempts) {
        this.maxWrtAttempts = maxWrtAttempts;
        return this;
    }

    public int getParallelLoadCacheMinimumThreshold() {
        return this.parallelLoadCacheMinThreshold;
    }

    public JdbcCacheStoreFactory setParallelLoadCacheMinimumThreshold(int parallelLoadCacheMinThreshold) {
        this.parallelLoadCacheMinThreshold = parallelLoadCacheMinThreshold;
        return this;
    }

    public JdbcType getType() {
        return this.type;
    }

    public JdbcCacheStoreFactory setType(JdbcType type) {
        this.type = type;
        return this;
    }

    public JdbcTypesTransformer getTransformer() {
        return this.transformer;
    }

    public JdbcCacheStoreFactory setTransformer(JdbcTypesTransformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public boolean isSqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public JdbcCacheStoreFactory setSqlEscapeAll(boolean sqlEscapeAll) {
        this.sqlEscapeAll = sqlEscapeAll;
        return this;
    }

    public String toString() {
        return S.toString(JdbcCacheStoreFactory.class, (Object)this);
    }
}

