/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc.dialect;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.gridgain.cache.store.jdbc.dialect.JdbcDialect;

public class BasicJdbcDialect
implements JdbcDialect {
    protected static final int DFLT_MAX_PARAMS_CNT = 2000;
    protected int maxParamsCnt = 2000;
    protected int fetchSize;

    protected static <T> String mkString(Iterable<T> elems, Function<T, String> f, String start, String sep, String end) {
        IgniteStringBuilder sb = new IgniteStringBuilder(start);
        boolean first = true;
        for (T elem : elems) {
            if (!first) {
                sb.app(sep);
            }
            sb.app(f.apply(elem));
            first = false;
        }
        return sb.app(end).toString();
    }

    protected static String mkString(Iterable<String> strs, String start, String sep, String end) {
        return BasicJdbcDialect.mkString(strs, Function.identity(), start, sep, end);
    }

    protected static String mkString(Iterable<String> strs, String sep) {
        return BasicJdbcDialect.mkString(strs, Function.identity(), "", sep, "");
    }

    protected static String repeat(String str, int cnt, String start, String sep, String end) {
        IgniteStringBuilder sb = new IgniteStringBuilder(str.length() * cnt + sep.length() * (cnt - 1) + start.length() + end.length());
        sb.app(start);
        for (int i = 0; i < cnt; ++i) {
            if (i > 0) {
                sb.app(sep);
            }
            sb.app(str);
        }
        return sb.app(end).toString();
    }

    private static String where(Collection<String> keyCols, int keyCnt) {
        IgniteStringBuilder sb = new IgniteStringBuilder();
        if (keyCols.size() == 1) {
            String keyCol = keyCols.iterator().next();
            if (keyCnt == 1) {
                sb.app(keyCol + "=?");
            } else {
                sb.app(BasicJdbcDialect.repeat("?", keyCnt, keyCol + " IN (", ",", ")"));
            }
        } else {
            String keyParams = BasicJdbcDialect.mkString(keyCols, s -> s + "=?", "(", " AND ", ")");
            sb.app(BasicJdbcDialect.repeat(keyParams, keyCnt, "", " OR ", ""));
        }
        return sb.toString();
    }

    @Override
    public String escape(String ident) {
        return "\"" + ident + "\"";
    }

    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = BasicJdbcDialect.mkString(keyCols, ",");
        return String.format("SELECT %1$s FROM (SELECT %1$s, ROW_NUMBER() OVER() AS rn FROM (SELECT %1$s FROM %2$s ORDER BY %1$s) AS tbl) AS tbl WHERE mod(rn, ?) = 0", cols, fullTblName);
    }

    @Override
    public String loadCacheRangeQuery(String fullTblName, Collection<String> keyCols, Iterable<String> uniqCols, boolean appendLowerBound, boolean appendUpperBound) {
        int idx;
        int keyCnt;
        assert (appendLowerBound || appendUpperBound);
        IgniteStringBuilder sb = new IgniteStringBuilder();
        String[] cols = keyCols.toArray(new String[0]);
        if (appendLowerBound) {
            sb.app("(");
            for (keyCnt = keyCols.size(); keyCnt > 0; --keyCnt) {
                for (idx = 0; idx < keyCnt; ++idx) {
                    if (idx == keyCnt - 1) {
                        sb.app(cols[idx]).app(" > ? ");
                        continue;
                    }
                    sb.app(cols[idx]).app(" = ? AND ");
                }
                if (keyCnt == 1) continue;
                sb.app("OR ");
            }
            sb.app(")");
        }
        if (appendLowerBound && appendUpperBound) {
            sb.app(" AND ");
        }
        if (appendUpperBound) {
            sb.app("(");
            for (keyCnt = keyCols.size(); keyCnt > 0; --keyCnt) {
                int lastIdx = keyCnt - 1;
                for (idx = 0; idx < keyCnt; ++idx) {
                    sb.app(cols[idx]);
                    if (idx == lastIdx) {
                        sb.app(keyCnt == keyCols.size() ? " <= ? " : " < ? ");
                        continue;
                    }
                    sb.app(" = ? AND ");
                }
                if (keyCnt == 1) continue;
                sb.app(" OR ");
            }
            sb.app(")");
        }
        return String.format("SELECT %s FROM %s WHERE %s", BasicJdbcDialect.mkString(uniqCols, ","), fullTblName, sb);
    }

    @Override
    public String loadCacheQuery(String fullTblName, Iterable<String> uniqCols) {
        return String.format("SELECT %s FROM %s", BasicJdbcDialect.mkString(uniqCols, ","), fullTblName);
    }

    @Override
    public String loadQuery(String fullTblName, Collection<String> keyCols, Iterable<String> cols, int keyCnt) {
        assert (!keyCols.isEmpty());
        String params = BasicJdbcDialect.where(keyCols, keyCnt);
        return String.format("SELECT %s FROM %s WHERE %s", BasicJdbcDialect.mkString(cols, ","), fullTblName, params);
    }

    @Override
    public String insertQuery(String fullTblName, Collection<String> keyCols, Collection<String> valCols) {
        Collection cols = Stream.concat(keyCols.stream(), valCols.stream()).collect(Collectors.toList());
        return String.format("INSERT INTO %s(%s) VALUES(%s)", fullTblName, BasicJdbcDialect.mkString(cols, ","), BasicJdbcDialect.repeat("?", cols.size(), "", ",", ""));
    }

    @Override
    public String updateQuery(String fullTblName, Collection<String> keyCols, Iterable<String> valCols) {
        String params = BasicJdbcDialect.mkString(valCols, s -> s + "=?", "", ",", "");
        return String.format("UPDATE %s SET %s WHERE %s", fullTblName, params, BasicJdbcDialect.where(keyCols, 1));
    }

    @Override
    public boolean hasMerge() {
        return false;
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        return "";
    }

    @Override
    public String removeQuery(String fullTblName, Iterable<String> keyCols) {
        String whereParams = BasicJdbcDialect.mkString(keyCols, s -> s + "=?", "", " AND ", "");
        return String.format("DELETE FROM %s WHERE %s", fullTblName, whereParams);
    }

    @Override
    public int getMaxParameterCount() {
        return this.maxParamsCnt;
    }

    public void setMaxParameterCount(int maxParamsCnt) {
        this.maxParamsCnt = maxParamsCnt;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }
}

