/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc.dialect;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gridgain.cache.store.jdbc.dialect.BasicJdbcDialect;

public class SqlServerDialect
extends BasicJdbcDialect {
    @Override
    public String escape(String ident) {
        return "[" + ident + "]";
    }

    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = SqlServerDialect.mkString(keyCols, ",");
        return String.format("SELECT %1$s FROM (SELECT %1$s, ROW_NUMBER() OVER(ORDER BY %1$s) AS rn FROM %2$s) tbl WHERE rn %% ? = 0 ORDER BY %1$s", cols, fullTblName);
    }

    @Override
    public boolean hasMerge() {
        return true;
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        Collection cols = Stream.concat(keyCols.stream(), uniqCols.stream()).collect(Collectors.toList());
        String colsLst = SqlServerDialect.mkString(cols, ", ");
        String match = SqlServerDialect.mkString(keyCols, col -> String.format("t.%s=v.%s", col, col), "", " AND ", "");
        String setCols = SqlServerDialect.mkString(uniqCols, col -> String.format("t.%s = v.%s", col, col), "", ", ", "");
        String valuesCols = SqlServerDialect.mkString(cols, col -> "v." + col, "", ", ", "");
        return String.format("MERGE INTO %s t USING (VALUES(%s)) AS v (%s)  ON %s WHEN MATCHED THEN  UPDATE SET %s WHEN NOT MATCHED THEN  INSERT (%s) VALUES (%s);", fullTblName, SqlServerDialect.repeat("?", cols.size(), "", ",", ""), colsLst, match, setCols, colsLst, valuesCols);
    }
}

