/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.cache.store.jdbc.dialect;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gridgain.cache.store.jdbc.dialect.BasicJdbcDialect;

public class Db2Dialect
extends BasicJdbcDialect {
    @Override
    public String loadCacheSelectRangeQuery(String fullTblName, Collection<String> keyCols) {
        String cols = Db2Dialect.mkString(keyCols, ",");
        return String.format("SELECT %1$s FROM (SELECT %1$s, ROW_NUMBER() OVER(ORDER BY %1$s) AS rn FROM %2$s) WHERE mod(rn, ?) = 0 ORDER BY %1$s", cols, fullTblName);
    }

    @Override
    public boolean hasMerge() {
        return true;
    }

    @Override
    public String mergeQuery(String fullTblName, Collection<String> keyCols, Collection<String> uniqCols) {
        Collection cols = Stream.concat(keyCols.stream(), uniqCols.stream()).collect(Collectors.toList());
        String colsLst = Db2Dialect.mkString(cols, ", ");
        String match = Db2Dialect.mkString(keyCols, col -> String.format("t.%s=v.%s", col, col), "", " AND ", "");
        String setCols = Db2Dialect.mkString(uniqCols, col -> String.format("t.%s = v.%s", col, col), "", ", ", "");
        String valuesCols = Db2Dialect.mkString(cols, col -> "v." + col, "", ", ", "");
        return String.format("MERGE INTO %s t USING (VALUES(%s)) AS v (%s)  ON %s WHEN MATCHED THEN  UPDATE SET %s WHEN NOT MATCHED THEN  INSERT (%s) VALUES (%s)", fullTblName, Db2Dialect.repeat("?", cols.size(), "", ",", ""), colsLst, match, setCols, colsLst, valuesCols);
    }
}

