/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.eviction.task;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.configuration.LowWatermarkConfiguration;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.EvictionView;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.gridgain.internal.eviction.EvictionMode;
import org.gridgain.internal.eviction.PrimaryReplicaProvider;
import org.gridgain.internal.eviction.task.EvictionRunner;
import org.gridgain.internal.eviction.task.EvictionTask;
import org.gridgain.internal.eviction.task.HistoryOnlyTask;
import org.gridgain.internal.eviction.task.LowWatermarkUpdater;
import org.gridgain.internal.eviction.task.RandomTask;

public class EvictionTaskFactory {
    private final ScheduledExecutorService scheduledExecutorService;
    private final LowWatermarkUpdater lowWatermarkUpdater;
    private final EvictionRunner evictionRunner;
    private final ClockService clockService;

    public EvictionTaskFactory(ScheduledExecutorService scheduledExecutorService, LowWatermark lowWatermark, LowWatermarkConfiguration lowWatermarkConfig, ClockService clockService, CatalogManager catalogManager, TableManager tableManager, SchemaManager schemaManager, PrimaryReplicaProvider primaryReplicaProvider, FailureProcessor failureProcessor, NodeProperties nodeProperties) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.clockService = clockService;
        this.lowWatermarkUpdater = new LowWatermarkUpdater(lowWatermark, lowWatermarkConfig, clockService);
        this.evictionRunner = new EvictionRunner(catalogManager, tableManager, schemaManager, clockService, primaryReplicaProvider, failureProcessor);
    }

    public EvictionTask createEvictionTask(String regionName, EvictionView evictionView) {
        EvictionMode evictionMode = EvictionMode.valueOf(evictionView.mode());
        switch (evictionMode) {
            case HISTORY_ONLY: {
                return new HistoryOnlyTask(this.scheduledExecutorService, this.lowWatermarkUpdater, evictionView.lwmUpdateInterval());
            }
            case RANDOM: {
                return new RandomTask(regionName, this.scheduledExecutorService, this.lowWatermarkUpdater, evictionView, this.evictionRunner, this.clockService);
            }
            case DISABLED: {
                throw new IllegalArgumentException("Eviction mode is DISABLED, cannot start eviction.");
            }
        }
        throw new IllegalArgumentException("Unsupported eviction mode: " + evictionMode);
    }
}

