/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.eviction.task;

import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.schema.configuration.LowWatermarkConfiguration;

public class LowWatermarkUpdater {
    private static final IgniteLogger LOG = Loggers.forClass(LowWatermarkUpdater.class);
    private final LowWatermark lowWatermark;
    private final LowWatermarkConfiguration lowWatermarkConfig;
    private final ClockService clockService;
    private int iteration = 0;

    public LowWatermarkUpdater(LowWatermark lowWatermark, LowWatermarkConfiguration lowWatermarkConfig, ClockService clockService) {
        this.lowWatermark = lowWatermark;
        this.lowWatermarkConfig = lowWatermarkConfig;
        this.clockService = clockService;
    }

    public HybridTimestamp updateLowWatermark() {
        HybridTimestamp newLowWatermarkCandidate = this.createNewLowWatermarkCandidate(++this.iteration);
        this.lowWatermark.updateLowWatermark(newLowWatermarkCandidate);
        return newLowWatermarkCandidate;
    }

    private HybridTimestamp createNewLowWatermarkCandidate(int iteration) {
        LOG.debug("Creating new low watermark candidate for iteration: " + iteration, new Object[0]);
        HybridTimestamp now = this.clockService.now();
        long value = Math.round(Math.pow(0.9, iteration) * (double)((Long)this.lowWatermarkConfig.dataAvailabilityTimeMillis().value()).longValue());
        if (value < this.clockService.maxClockSkewMillis()) {
            return now.subtractPhysicalTime(this.clockService.maxClockSkewMillis());
        }
        LOG.debug("New low watermark candidate for iteration: " + iteration + " is " + value + "ms behind now", new Object[0]);
        return now.subtractPhysicalTime(value);
    }
}

