/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.eviction;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileView;
import org.apache.ignite.internal.util.StringUtils;
import org.gridgain.internal.eviction.EvictionMode;
import org.gridgain.internal.eviction.EvictionTaskWrapper;
import org.gridgain.internal.eviction.task.EvictionTask;
import org.gridgain.internal.eviction.task.EvictionTaskFactory;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.MissingRequiredFeaturesException;

public class EvictionScannerTask
implements Runnable {
    private static final IgniteLogger LOG = Loggers.forClass(EvictionScannerTask.class);
    private final Map<String, EvictionTaskWrapper> evictionTasks;
    private final VolatilePageMemoryStorageEngine storageEngine;
    private final ExecutorService executorService;
    private final EvictionTaskFactory evictionTaskFactory;
    private final LicenseFeatureChecker licenseChecker;
    private final FailureProcessor failureProcessor;

    EvictionScannerTask(ExecutorService executorService, Map<String, EvictionTaskWrapper> evictionTasks, VolatilePageMemoryStorageEngine storageEngine, EvictionTaskFactory evictionTaskFactory, LicenseFeatureChecker licenseChecker, FailureProcessor failureProcessor) {
        this.executorService = executorService;
        this.evictionTasks = evictionTasks;
        this.storageEngine = storageEngine;
        this.evictionTaskFactory = evictionTaskFactory;
        this.licenseChecker = licenseChecker;
        this.failureProcessor = failureProcessor;
    }

    @Override
    public void run() {
        try {
            for (Map.Entry regionEntry : this.storageEngine.regions().entrySet()) {
                long regionUsedBytes = ((VolatilePageMemoryDataRegion)regionEntry.getValue()).getUsedBytes();
                VolatilePageMemoryProfileView profileCfg = (VolatilePageMemoryProfileView)((VolatilePageMemoryDataRegion)regionEntry.getValue()).getConfiguration().value();
                if (profileCfg == null) {
                    LOG.error("Data region configuration is not found for region '{}'", new Object[]{regionEntry.getKey()});
                    continue;
                }
                if (EvictionMode.DISABLED.name().equals(profileCfg.eviction().mode())) {
                    this.cancelEvictionTaskIfNecessary((String)regionEntry.getKey());
                    continue;
                }
                this.licenseChecker.checkFeature(LicenseFeature.EVICTION);
                long evictionThresholdInBytes = StringUtils.parseStorageStringSize((String)profileCfg.eviction().threshold(), () -> ((VolatilePageMemoryProfileView)profileCfg).maxSizeBytes());
                if (regionUsedBytes >= evictionThresholdInBytes) {
                    LOG.info("Starting eviction in a region '{}', current data usage is '{}', threshold is '{}'", new Object[]{regionEntry.getKey(), regionUsedBytes, evictionThresholdInBytes});
                    EvictionTaskWrapper taskWrapper = this.evictionTasks.get(regionEntry.getKey());
                    if (taskWrapper != null) continue;
                    EvictionTask task = this.evictionTaskFactory.createEvictionTask((String)regionEntry.getKey(), profileCfg.eviction());
                    Future<?> future = this.executorService.submit(task);
                    this.evictionTasks.put((String)regionEntry.getKey(), new EvictionTaskWrapper(future, task));
                    continue;
                }
                this.cancelEvictionTaskIfNecessary((String)regionEntry.getKey());
            }
        }
        catch (MissingRequiredFeaturesException e) {
            LOG.error("Eviction cannot be started, because it is not allowed by the license", (Throwable)e);
        }
        catch (Exception e) {
            this.failureProcessor.process(new FailureContext((Throwable)e, "Error during scanning data regions for eviction thresholds"));
        }
    }

    private void cancelEvictionTaskIfNecessary(String regionName) {
        EvictionTaskWrapper taskWrapper = this.evictionTasks.get(regionName);
        if (taskWrapper != null) {
            LOG.info("Stopping eviction in a region '{}'", new Object[]{regionName});
            taskWrapper.cancel();
            this.evictionTasks.remove(regionName);
        }
    }
}

