/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.eviction.task;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowImpl;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.storage.pagememory.index.AbstractPageMemoryIndexStorage;
import org.apache.ignite.internal.storage.pagememory.index.common.IndexRowKey;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.table.distributed.TableIndexStoragesSupplier;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.gridgain.internal.eviction.PrimaryReplicaProvider;
import org.jetbrains.annotations.Nullable;

public class EvictionRunner {
    private static final IgniteLogger LOG = Loggers.forClass(EvictionRunner.class);
    private static final int FAILURE_CNT_THRESHOLD = 5;
    private final CatalogManager catalogManager;
    private final TableManager tableManager;
    private final SchemaManager schemaManager;
    private final ClockService clockService;
    private final PrimaryReplicaProvider primaryReplicaProvider;
    private final FailureProcessor failureProcessor;
    private final NodeProperties nodeProperties;

    public EvictionRunner(CatalogManager catalogManager, TableManager tableManager, SchemaManager schemaManager, ClockService clockService, PrimaryReplicaProvider primaryReplicaProvider, FailureProcessor failureProcessor, NodeProperties nodeProperties) {
        this.catalogManager = catalogManager;
        this.tableManager = tableManager;
        this.schemaManager = schemaManager;
        this.clockService = clockService;
        this.primaryReplicaProvider = primaryReplicaProvider;
        this.failureProcessor = failureProcessor;
        this.nodeProperties = nodeProperties;
    }

    public void evict(String regionName, long batchSize) {
        block7: {
            try {
                long remainingRows = batchSize;
                int catalogVersion = this.catalogManager.activeCatalogVersion(this.clockService.nowLong());
                List tables = this.catalogManager.catalog(catalogVersion).tables().stream().filter(x -> x.storageProfile().equals(regionName)).collect(Collectors.toList());
                Collections.shuffle(tables);
                for (CatalogTableDescriptor table : tables) {
                    List<Integer> partitions = this.nodeProperties.colocationEnabled() ? this.primaryReplicaProvider.getPartitionsByZoneId(table.zoneId()) : this.primaryReplicaProvider.getPartitionsByTableId(table.id());
                    Collections.shuffle(partitions);
                    TableViewInternal tableViewInternal = this.tableManager.table(table.id());
                    SchemaRegistry schemaRegistry = this.schemaManager.schemaRegistry(table.id());
                    SchemaDescriptor schemaDescriptor = schemaRegistry.schema(tableViewInternal.schemaView().lastKnownSchemaVersion());
                    int primaryKeyIndexId = table.primaryKeyIndexId();
                    HashMap<IndexRowKey, Row> rowsToDelete = new HashMap<IndexRowKey, Row>();
                    int failuresCnt = 0;
                    while ((long)rowsToDelete.size() < remainingRows && failuresCnt < 5) {
                        for (int partitionId : partitions) {
                            try {
                                IndexRowKey key;
                                AbstractPageMemoryIndexStorage indexStorage = this.getIndexStorage(tableViewInternal, primaryKeyIndexId, partitionId);
                                if (indexStorage == null || (key = indexStorage.getRandomRow()) == null || (long)rowsToDelete.size() >= batchSize || rowsToDelete.containsKey(key) && ++failuresCnt >= 5) break;
                                Row row = this.wrapBinaryRow(schemaDescriptor, key.indexColumns().valueBuffer());
                                rowsToDelete.put(key, row);
                            }
                            catch (Exception e) {
                                this.failureProcessor.process(new FailureContext((Throwable)e, "Failed to remove row from index"));
                            }
                        }
                        if (!rowsToDelete.isEmpty()) continue;
                    }
                    if (rowsToDelete.isEmpty()) continue;
                    LOG.info(IgniteStringFormatter.format((String)"Evicting {} rows from table {} ", (Object[])new Object[]{rowsToDelete.size(), table.name()}), new Object[0]);
                    tableViewInternal.internalTable().deleteAll(rowsToDelete.values(), null);
                    remainingRows -= (long)rowsToDelete.size();
                }
            }
            catch (Exception e) {
                if (ExceptionUtils.hasCause((Throwable)e, (Class[])new Class[]{NodeStoppingException.class})) break block7;
                this.failureProcessor.process(new FailureContext((Throwable)e, "Failed to evict rows"));
            }
        }
    }

    private Row wrapBinaryRow(SchemaDescriptor schemaDescriptor, ByteBuffer binaryTuple) {
        BinaryRowImpl binaryRow = new BinaryRowImpl(schemaDescriptor.version(), binaryTuple);
        return Row.wrapKeyOnlyBinaryRow((SchemaDescriptor)schemaDescriptor, (BinaryRow)binaryRow);
    }

    @Nullable
    private AbstractPageMemoryIndexStorage getIndexStorage(TableViewInternal tableViewInternal, int pkIndexId, int partitionId) {
        TableIndexStoragesSupplier storagesSupplier = ((TableImpl)tableViewInternal).indexStorageAdapters(partitionId);
        if (storagesSupplier != null) {
            Map indexStorages = storagesSupplier.get();
            return (AbstractPageMemoryIndexStorage)((TableSchemaAwareIndexStorage)indexStorages.get(pkIndexId)).storage();
        }
        return null;
    }
}

