/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.storage;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.storage.EncryptedDataEncryptionKeysSerializer;
import org.gridgain.internal.encryption.storage.EncryptedKeyChain;
import org.gridgain.internal.encryption.storage.KeyChain;
import org.gridgain.internal.encryption.storage.KeyChainEncryptor;
import org.gridgain.internal.encryption.storage.KeyStorage;
import org.jetbrains.annotations.Nullable;

public class VaultKeyStorage
implements KeyStorage {
    public static final String ENCRYPTION_KEYS_PREFIX = "table-encryption-keys-";
    private static final ByteArray ENCRYPTION_KEYS_RANGE_START = ByteArray.fromString((String)"table-encryption-keys-");
    private static final ByteArray ENCRYPTION_KEYS_RANGE_END = ByteArray.fromString((String)StringUtils.incrementLastChar((String)"table-encryption-keys-"));
    private final KeyChainEncryptor encryptor;
    private final VaultManager vaultManager;

    public VaultKeyStorage(VaultManager vaultManager, EncryptionManager encryptionManager) {
        this.vaultManager = vaultManager;
        this.encryptor = new KeyChainEncryptor(encryptionManager);
    }

    @Override
    public void store(String id, KeyChain keyChain) {
        byte[] bytes = VersionedSerialization.toBytes((Object)this.encryptor.encrypt(keyChain), (VersionedSerializer)EncryptedDataEncryptionKeysSerializer.INSTANCE);
        this.vaultManager.put(VaultKeyStorage.toVaultKey(id), bytes);
    }

    @Override
    public void storeAll(Map<String, KeyChain> keyChains) {
        Map<ByteArray, byte[]> encryptedKeyChains = keyChains.entrySet().stream().collect(Collectors.toMap(e -> VaultKeyStorage.toVaultKey((String)e.getKey()), e -> VersionedSerialization.toBytes((Object)this.encryptor.encrypt((KeyChain)e.getValue()), (VersionedSerializer)EncryptedDataEncryptionKeysSerializer.INSTANCE)));
        this.vaultManager.putAll(encryptedKeyChains);
    }

    @Override
    public void remove(String id) {
        this.vaultManager.remove(VaultKeyStorage.toVaultKey(id));
    }

    @Override
    @Nullable
    public KeyChain getKeyChain(String id) {
        VaultEntry vaultEntry = this.vaultManager.get(VaultKeyStorage.toVaultKey(id));
        return vaultEntry != null ? this.deserialize(vaultEntry.value()) : null;
    }

    @Override
    public Map<String, KeyChain> getKeyChains() {
        Map<String, KeyChain> map;
        block8: {
            Cursor cursor = this.vaultManager.range(ENCRYPTION_KEYS_RANGE_START, ENCRYPTION_KEYS_RANGE_END);
            try {
                map = cursor.stream().collect(Collectors.toMap(entry -> VaultKeyStorage.removePrefix(entry.key()), entry -> this.deserialize(entry.value())));
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new StorageException("Failed to restore data encryption keys for tables", (Throwable)e);
                }
            }
            cursor.close();
        }
        return map;
    }

    private KeyChain deserialize(byte[] arr) {
        EncryptedKeyChain encryptedKeyChain = (EncryptedKeyChain)VersionedSerialization.fromBytes((byte[])arr, (VersionedSerializer)EncryptedDataEncryptionKeysSerializer.INSTANCE);
        return this.encryptor.decrypt(encryptedKeyChain);
    }

    private static ByteArray toVaultKey(String chainId) {
        return ByteArray.fromString((String)(ENCRYPTION_KEYS_PREFIX + chainId));
    }

    private static String removePrefix(ByteArray key) {
        return key.toString().substring(ENCRYPTION_KEYS_PREFIX.length());
    }
}

