/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.reencryption;

import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.gridgain.internal.encryption.reencryption.ReencryptionStatus;
import org.gridgain.internal.encryption.reencryption.ReencryptionStatusSerializer;
import org.gridgain.internal.encryption.reencryption.ReencryptionStorage;
import org.jetbrains.annotations.Nullable;

public class ReencryptionStorageImpl
implements ReencryptionStorage {
    private static final IgniteLogger LOG = Loggers.forClass(ReencryptionStorageImpl.class);
    private static final String PREFIX = "reenc";
    private static final String REENCRYPTION_KEY = "reenc_group_%s_key_%s";
    private static final String MAPPING_PREFIX = "reenc_mapping";
    private final VaultManager vaultManager;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public ReencryptionStorageImpl(VaultManager vaultManager) {
        this.vaultManager = vaultManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReencryption(int groupId, int keyId, boolean backgroundEnabled) {
        this.lock.writeLock().lock();
        try {
            HashMap<ByteArray, byte[]> entries = new HashMap<ByteArray, byte[]>();
            ByteArray mappingKey = ReencryptionStorageImpl.mapping(groupId);
            byte[] mappingVal = ReencryptionStorageImpl.toBytes(keyId);
            entries.put(mappingKey, mappingVal);
            ByteArray groupKey = ReencryptionStorageImpl.groupKeyIdKey(groupId, keyId);
            ReencryptionStatus.State state = backgroundEnabled ? ReencryptionStatus.State.IN_PROGRESS : ReencryptionStatus.State.BACKGROUND_DISABLED;
            ReencryptionStatus status = new ReencryptionStatus(keyId, state);
            entries.put(groupKey, VersionedSerialization.toBytes((Object)status, (VersionedSerializer)ReencryptionStatusSerializer.INSTANCE));
            this.vaultManager.putAll(entries);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReencryptionStatus lastKeyReencryptionStatus(int groupId) {
        this.lock.readLock().lock();
        try {
            ByteArray mappingKey = ReencryptionStorageImpl.mapping(groupId);
            VaultEntry vaultEntry = this.vaultManager.get(mappingKey);
            if (vaultEntry == null) {
                ReencryptionStatus reencryptionStatus = null;
                return reencryptionStatus;
            }
            int keyId = ReencryptionStorageImpl.toInt(vaultEntry.value());
            ByteArray key = ReencryptionStorageImpl.groupKeyIdKey(groupId, keyId);
            if ((vaultEntry = this.vaultManager.get(key)) == null) {
                ReencryptionStatus reencryptionStatus = null;
                return reencryptionStatus;
            }
            ReencryptionStatus reencryptionStatus = (ReencryptionStatus)VersionedSerialization.fromBytes((byte[])vaultEntry.value(), (VersionedSerializer)ReencryptionStatusSerializer.INSTANCE);
            return reencryptionStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReencryptionStatus groupReencryptionStatus(int groupId, int keyId) {
        this.lock.readLock().lock();
        try {
            ByteArray key = ReencryptionStorageImpl.groupKeyIdKey(groupId, keyId);
            VaultEntry vaultEntry = this.vaultManager.get(key);
            if (vaultEntry == null) {
                ReencryptionStatus reencryptionStatus = null;
                return reencryptionStatus;
            }
            ReencryptionStatus reencryptionStatus = (ReencryptionStatus)VersionedSerialization.fromBytes((byte[])vaultEntry.value(), (VersionedSerializer)ReencryptionStatusSerializer.INSTANCE);
            return reencryptionStatus;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void updateProgress(int groupId, int keyId, int partitionId, int index) {
        this.update(groupId, keyId, reencryptionStatus -> reencryptionStatus.updateProgress(partitionId, index));
    }

    public void setCount(int groupId, int keyId, int partitionId, int count) {
        this.update(groupId, keyId, reencryptionStatus -> reencryptionStatus.updateCount(partitionId, count));
    }

    public void finishReencryption(int groupId, int keyId, ReencryptionStorage.FinishReason reason) {
        LOG.info("Finish reencryption for " + groupId + " for key " + keyId + " with reason " + reason, new Object[0]);
        this.update(groupId, keyId, reencryptionStatus -> {
            switch (reason) {
                case COMPLETED: {
                    reencryptionStatus.updateState(ReencryptionStatus.State.COMPLETED);
                    break;
                }
                case DEK_REROTATE: {
                    reencryptionStatus.updateState(ReencryptionStatus.State.CANCELED_DUE_TO_NEW_REENCRYPTION);
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(int groupId, int keyId, Consumer<ReencryptionStatus> upgradeFunction) {
        this.lock.writeLock().lock();
        try {
            ByteArray key = ReencryptionStorageImpl.groupKeyIdKey(groupId, keyId);
            VaultEntry vaultEntry = this.vaultManager.get(key);
            if (vaultEntry == null) {
                return;
            }
            ReencryptionStatus reencryptionStatus = (ReencryptionStatus)VersionedSerialization.fromBytes((byte[])vaultEntry.value(), (VersionedSerializer)ReencryptionStatusSerializer.INSTANCE);
            upgradeFunction.accept(reencryptionStatus);
            this.vaultManager.put(key, VersionedSerialization.toBytes((Object)reencryptionStatus, (VersionedSerializer)ReencryptionStatusSerializer.INSTANCE));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static ByteArray groupKeyIdKey(int groupId, int keyId) {
        return ByteArray.fromString((String)String.format(REENCRYPTION_KEY, groupId, keyId));
    }

    private static ByteArray mapping(int groupId) {
        return ByteArray.fromString((String)(MAPPING_PREFIX + groupId));
    }

    private static int toInt(byte[] arr) {
        return arr[0] & 0xFF | (arr[1] & 0xFF) << 8 | (arr[2] & 0xFF) << 16 | (arr[3] & 0xFF) << 24;
    }

    private static byte[] toBytes(int i) {
        byte[] result = new byte[]{(byte)i, (byte)(i >>> 8), (byte)(i >>> 16), (byte)(i >>> 24)};
        return result;
    }
}

