/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.provider;

import javax.crypto.Cipher;
import org.gridgain.internal.encryption.provider.KeyProvider;
import org.gridgain.internal.encryption.provider.aws.AwsKmsKeyProvider;
import org.gridgain.internal.encryption.provider.aws.AwsKmsKeyProviderView;
import org.gridgain.internal.encryption.provider.configuration.KeyProviderView;
import org.gridgain.internal.encryption.provider.keystore.KeyStoreKeyProvider;
import org.gridgain.internal.encryption.provider.keystore.KeyStoreKeyProviderView;
import org.gridgain.internal.encryption.provider.secret.SecretPhraseKeyProvider;
import org.gridgain.internal.encryption.provider.secret.SecretPhraseKeyProviderView;
import org.gridgain.internal.encryption.utils.KeyProviderValidationUtils;

public class KeyProviderFactory {
    public static KeyProvider createFromConfiguration(KeyProviderView keyProviderView) {
        String providerName = KeyProviderValidationUtils.normalizeProviderName((String)keyProviderView.name());
        try {
            if (keyProviderView instanceof SecretPhraseKeyProviderView) {
                SecretPhraseKeyProviderView view = (SecretPhraseKeyProviderView)keyProviderView;
                Cipher cipher = Cipher.getInstance(view.cipher());
                return SecretPhraseKeyProvider.create(providerName, view.secretPhrase(), view.salt(), cipher);
            }
            if (keyProviderView instanceof KeyStoreKeyProviderView) {
                KeyStoreKeyProviderView view = (KeyStoreKeyProviderView)keyProviderView;
                Cipher cipher = Cipher.getInstance(view.cipher());
                return KeyStoreKeyProvider.create(providerName, view.keyStoreType(), view.path(), view.password(), view.activeKeyName(), cipher);
            }
            if (keyProviderView instanceof AwsKmsKeyProviderView) {
                AwsKmsKeyProviderView view = (AwsKmsKeyProviderView)keyProviderView;
                return AwsKmsKeyProvider.create(providerName, view.keyId());
            }
            throw new IllegalArgumentException("Unexpected key provider view: " + keyProviderView);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create key provider [name=" + providerName + ", type=" + keyProviderView.type() + "]", e);
        }
    }
}

