/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.gridgain.internal.encryption.storage.EncryptedKeyChain;

public class EncryptedDataEncryptionKeysSerializer
extends VersionedSerializer<EncryptedKeyChain> {
    public static final EncryptedDataEncryptionKeysSerializer INSTANCE = new EncryptedDataEncryptionKeysSerializer();

    protected void writeExternalData(EncryptedKeyChain chain, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)chain.activeKeyId());
        List<byte[]> keys = chain.keys();
        out.writeVarInt((long)keys.size());
        for (byte[] bytes : keys) {
            EncryptedDataEncryptionKeysSerializer.writeByteArrayWithLength((byte[])bytes, (IgniteDataOutput)out);
        }
    }

    protected EncryptedKeyChain readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int activeKey = in.readVarIntAsInt();
        int length = in.readVarIntAsInt();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (int i = 0; i < length; ++i) {
            keys.add(EncryptedDataEncryptionKeysSerializer.readByteArrayWithLength((IgniteDataInput)in));
        }
        return new EncryptedKeyChain(activeKey, keys);
    }
}

