/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.storage;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.encryption.DataEncryptionKeyManager;
import org.gridgain.internal.encryption.DataEncryptionKeyNotFoundException;
import org.gridgain.internal.encryption.DataKeyGenerator;
import org.gridgain.internal.encryption.DekRotationListener;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.event.EncryptionEvent;
import org.gridgain.internal.encryption.event.EncryptionEventParameters;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.storage.KeyChain;
import org.gridgain.internal.encryption.storage.KeyStorage;
import org.jetbrains.annotations.Nullable;

public class DataEncryptionKeyManagerImpl
implements DataEncryptionKeyManager,
EventListener<EncryptionEventParameters> {
    private static final IgniteLogger LOG = Loggers.forClass(DataEncryptionKeyManagerImpl.class);
    private final Map<String, KeyChain> keysByChainId = new ConcurrentHashMap<String, KeyChain>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final FailureProcessor failureProcessor;
    private final EncryptionManager encryptionManager;
    private final KeyStorage storage;
    private final List<DekRotationListener> listeners = new CopyOnWriteArrayList<DekRotationListener>();

    public DataEncryptionKeyManagerImpl(KeyStorage storage, EncryptionManager encryptionManager, FailureProcessor failureProcessor) {
        this.storage = storage;
        this.failureProcessor = failureProcessor;
        this.encryptionManager = encryptionManager;
    }

    public DataEncryptionKey activeKey(String chainId) {
        KeyChain chain = this.keysByChainId.get(chainId);
        if (chain == null) {
            throw new DataEncryptionKeyNotFoundException(chainId);
        }
        return chain.activeKey();
    }

    public DataEncryptionKey getKey(String chainId, int keyId) {
        KeyChain chain = this.keysByChainId.get(chainId);
        if (chain == null) {
            throw new DataEncryptionKeyNotFoundException(chainId, keyId);
        }
        DataEncryptionKey key = chain.getKey(keyId);
        if (key == null) {
            throw new DataEncryptionKeyNotFoundException(chainId, keyId);
        }
        return key;
    }

    public boolean keyChainExists(String chainId) {
        return this.keysByChainId.containsKey(chainId);
    }

    public boolean createKeyChain(String chainId, DataEncryptionKey key, @Nullable String providerName) {
        return (Boolean)IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.keysByChainId.computeIfAbsent(chainId, id -> {
            KeyChain result = new KeyChain(key, providerName);
            this.storage.store(chainId, result);
            return result;
        }).activeKey() == key);
    }

    public void addKey(String chainId, DataEncryptionKey newKey) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            KeyChain chain = this.keysByChainId.get(chainId);
            if (chain == null) {
                throw new DataEncryptionKeyNotFoundException(chainId);
            }
            chain.addKey(newKey);
            this.storage.store(chainId, chain);
        });
    }

    public void changeActiveKey(String chainId, int keyId) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            KeyChain chain = this.keysByChainId.get(chainId);
            if (chain == null) {
                throw new DataEncryptionKeyNotFoundException(chainId, keyId);
            }
            if (!chain.changeActiveKey(keyId)) {
                throw new DataEncryptionKeyNotFoundException(chainId, keyId);
            }
        });
    }

    public void remove(String chainId) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            this.keysByChainId.computeIfPresent(chainId, (id, chain) -> {
                this.storage.remove((String)id);
                return null;
            });
            LOG.debug("Key(s) removed. [tableId=" + chainId + "]", new Object[0]);
        });
    }

    public void rotateKey(String chainId) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            KeyChain keyChain = this.keysByChainId.get(chainId);
            if (keyChain == null) {
                throw new DataEncryptionKeyNotFoundException(chainId);
            }
            int latestKeyId = keyChain.keys().stream().map(DataEncryptionKey::id).max(Integer::compareTo).orElse(0);
            DataEncryptionKey newKey = DataKeyGenerator.create(latestKeyId + 1);
            this.addKey(chainId, newKey);
            this.changeActiveKey(chainId, newKey.id());
            LOG.info("Key successfully rotated. [chainId=" + chainId + ", newKeyId=" + newKey.id() + "]", new Object[0]);
            this.listeners.forEach(listener -> listener.onDekRotationCompleted(chainId, latestKeyId, newKey.id()));
        });
    }

    public void registerRotationListener(DekRotationListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterRotationListener(DekRotationListener listener) {
        this.listeners.remove(listener);
    }

    private void doChangeMasterKey() {
        LOG.info("Start master key change", new Object[0]);
        try {
            IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> this.storage.storeAll(this.keysByChainId));
            LOG.info("Master key successfully changed", new Object[0]);
        }
        catch (Exception e) {
            this.failureProcessor.process(new FailureContext((Throwable)e, "Unable to change master key locally."));
        }
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        Map<String, KeyChain> keyChains = this.storage.getKeyChains();
        this.keysByChainId.putAll(keyChains);
        this.storage.storeAll(keyChains);
        this.encryptionManager.listen((Event)EncryptionEvent.ACTIVE_PROVIDER_UPDATED, (EventListener)this);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.busyLock.block();
        this.encryptionManager.removeListener((Event)EncryptionEvent.ACTIVE_PROVIDER_UPDATED, (EventListener)this);
        this.listeners.clear();
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Boolean> notify(EncryptionEventParameters parameters) {
        if (parameters.type() == EncryptionEvent.ACTIVE_PROVIDER_UPDATED) {
            this.doChangeMasterKey();
        }
        return CompletableFutures.falseCompletedFuture();
    }
}

