/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.provider.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import org.gridgain.internal.encryption.CannotInitKeyProviderException;
import org.gridgain.internal.encryption.InvalidKeyProviderConfigurationException;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.provider.KeyProvider;
import org.gridgain.internal.encryption.utils.EncryptionUtils;
import org.jetbrains.annotations.Nullable;

public class KeyStoreKeyProvider
implements KeyProvider {
    private static final Random RANDOM_INSTANCE = new SecureRandom();
    private final String keyStoreType;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String activeKekName;
    private final String providerName;
    private final Map<String, Key> localCachedKeys;
    private final Cipher cipher;

    public KeyStoreKeyProvider(String providerName, String keyStoreType, String keyStorePath, String keyStorePassword, String activeKekName, Cipher cipher) {
        this.providerName = providerName;
        this.keyStoreType = keyStoreType;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.activeKekName = activeKekName;
        this.localCachedKeys = new ConcurrentHashMap<String, Key>();
        this.cipher = cipher;
    }

    public static KeyStoreKeyProvider create(String providerName, String keyStoreType, String keyStorePath, String keyStorePassword, String activeKekName, Cipher cipher) {
        KeyStoreKeyProvider p = new KeyStoreKeyProvider(providerName, keyStoreType, keyStorePath, keyStorePassword, activeKekName, cipher);
        p.loadKekFromKeystore(activeKekName);
        return p;
    }

    /*
     * Loose catch block
     */
    private Key loadKekFromKeystore(String kekName) {
        Key key;
        InputStream is;
        char[] password;
        block12: {
            password = null;
            is = Files.newInputStream(Path.of(this.keyStorePath, new String[0]), StandardOpenOption.READ);
            KeyStore ks = KeyStore.getInstance(this.keyStoreType);
            password = this.keyStorePassword.toCharArray();
            ks.load(is, password);
            Key ret = ks.getKey(kekName, password);
            if (ret == null) {
                throw new InvalidKeyProviderConfigurationException(this.providerName, "Could not find key for alias: " + kekName);
            }
            key = ret;
            if (is == null) break block12;
            is.close();
        }
        EncryptionUtils.clear(password);
        return key;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException e) {
                        throw new InvalidKeyProviderConfigurationException(this.providerName, String.format("File '%s' not found", e.getMessage()), (Throwable)e);
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new CannotInitKeyProviderException(this.providerName, (Throwable)e);
                    }
                }
                catch (Throwable throwable3) {
                    EncryptionUtils.clear(password);
                    throw throwable3;
                }
            }
        }
    }

    private Key cachedKey(String keyName) {
        return this.localCachedKeys.computeIfAbsent(keyName, this::loadKekFromKeystore);
    }

    public byte[] encryptKey(DataEncryptionKey key) {
        Key localKek = this.cachedKey(this.activeKekName);
        return EncryptionUtils.encryptKey(RANDOM_INSTANCE, key, localKek, this.cipher.getAlgorithm());
    }

    public DataEncryptionKey decryptKey(byte[] data, @Nullable String keyIdentifier) {
        Key kek = keyIdentifier == null ? this.cachedKey(this.activeKekName) : this.cachedKey(keyIdentifier);
        return EncryptionUtils.decryptKey(data, kek, this.cipher.getAlgorithm());
    }

    public String getProviderIdentifier() {
        return this.providerName;
    }

    public String getActiveKeyIdentifier() {
        return this.activeKekName;
    }
}

