/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.provider.aws;

import java.net.URI;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.IgniteException;
import org.gridgain.internal.encryption.DataEncryptionKeySerializer;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.provider.KeyProvider;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.KmsException;
import software.amazon.awssdk.services.kms.model.NotFoundException;

public class AwsKmsKeyProvider
implements KeyProvider {
    private static final IgniteLogger LOG = Loggers.forClass(AwsKmsKeyProvider.class);
    private final String providerName;
    private final String keyId;
    private final KmsClient kmsClient;
    private URI endpointUri;

    private AwsKmsKeyProvider(String providerName, String keyId) {
        this.providerName = providerName;
        this.keyId = keyId;
        String endpoint = System.getProperty("aws.endpoint");
        if (endpoint != null && !endpoint.isEmpty()) {
            this.endpointUri = URI.create(endpoint);
        }
        this.kmsClient = this.createKmsClient();
        this.verifyKeyId(keyId);
    }

    public static AwsKmsKeyProvider create(String providerName, String keyId) {
        return new AwsKmsKeyProvider(providerName, keyId);
    }

    private void verifyKeyId(String keyId) {
        LOG.info("Verifying KMS key existence [keyId={}]", new Object[]{keyId});
        try {
            DescribeKeyRequest request = (DescribeKeyRequest)DescribeKeyRequest.builder().keyId(keyId).build();
            DescribeKeyResponse response = this.kmsClient.describeKey(request);
            boolean isEnabled = response.keyMetadata().enabled();
            if (!isEnabled) {
                throw new IgniteException(GridgainErrorGroups.Encryption.AWS_KMS_KEY_DISABLED_ERR, "KMS key is not enabled: " + keyId);
            }
            LOG.info("KMS key is enabled [keyId={}, keyArn={}]", new Object[]{keyId, response.keyMetadata().arn()});
        }
        catch (NotFoundException e) {
            throw new IgniteException(GridgainErrorGroups.Encryption.AWS_KMS_KEY_NOT_FOUND_ERR, "Provided KMS key does not exist: " + keyId, (Throwable)e);
        }
        catch (KmsException e) {
            throw new IgniteException(GridgainErrorGroups.Encryption.AWS_KMS_COMMON_ERR, "Failed to verify key existence", (Throwable)e);
        }
    }

    public byte[] encryptKey(DataEncryptionKey key) {
        byte[] serKey = DataEncryptionKeySerializer.serialize(key);
        EncryptRequest encryptReq = (EncryptRequest)EncryptRequest.builder().keyId(this.keyId).plaintext(SdkBytes.fromByteArray((byte[])serKey)).build();
        EncryptResponse encryptRes = this.kmsClient.encrypt(encryptReq);
        return encryptRes.ciphertextBlob().asByteArray();
    }

    public DataEncryptionKey decryptKey(byte[] data, @Nullable String keyIdentifier) {
        DecryptRequest decryptReq = (DecryptRequest)DecryptRequest.builder().ciphertextBlob(SdkBytes.fromByteArray((byte[])data)).keyId(keyIdentifier).build();
        DecryptResponse decryptRes = this.kmsClient.decrypt(decryptReq);
        byte[] serKey = decryptRes.plaintext().asByteArray();
        return DataEncryptionKeySerializer.deserialize(serKey);
    }

    public String getProviderIdentifier() {
        return this.providerName;
    }

    public String getActiveKeyIdentifier() {
        return this.keyId;
    }

    private KmsClient createKmsClient() {
        DefaultCredentialsProvider defaultCredentialsProvider = DefaultCredentialsProvider.builder().build();
        KmsClientBuilder builder = KmsClient.builder();
        if (this.endpointUri != null) {
            builder.endpointOverride(this.endpointUri);
        }
        return (KmsClient)((KmsClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)defaultCredentialsProvider)).build();
    }
}

