/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.validation.Validator;
import org.gridgain.internal.encryption.configuration.EncryptionExtensionConfigurationSchema;
import org.gridgain.internal.encryption.provider.aws.AwsKmsKeyProviderConfigurationSchema;
import org.gridgain.internal.encryption.provider.keystore.KeyStoreKeyProviderConfigurationSchema;
import org.gridgain.internal.encryption.provider.secret.SecretPhraseKeyProviderConfigurationSchema;
import org.gridgain.internal.encryption.validator.ActiveProviderValidatorImpl;
import org.gridgain.internal.encryption.validator.FileExistsValidatorImpl;
import org.gridgain.internal.encryption.validator.KeyProviderValidatorImpl;
import org.gridgain.internal.encryption.validator.RequiresEncryptionSupportValidatorImpl;
import org.gridgain.internal.encryption.validator.SizeValidator;

@AutoService(value={ConfigurationModule.class})
public class EncryptionConfigurationModule
implements ConfigurationModule {
    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    public Collection<Class<?>> schemaExtensions() {
        return List.of(EncryptionExtensionConfigurationSchema.class);
    }

    public Set<Validator<?, ?>> validators() {
        return Set.of(ActiveProviderValidatorImpl.INSTANCE, KeyProviderValidatorImpl.INSTANCE, SizeValidator.INSTANCE, FileExistsValidatorImpl.INSTANCE, RequiresEncryptionSupportValidatorImpl.INSTANCE);
    }

    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return List.of(SecretPhraseKeyProviderConfigurationSchema.class, KeyStoreKeyProviderConfigurationSchema.class, AwsKmsKeyProviderConfigurationSchema.class);
    }
}

