/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigUtil;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConverterToMapVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.gridgain.internal.encryption.configuration.EncryptionExtensionConfiguration;
import org.gridgain.internal.encryption.configuration.EncryptionExtensionView;
import org.gridgain.internal.encryption.configuration.EncryptionView;

class EncryptionConfig {
    private static final String ENCRYPTION_CONFIG_NAME = "encryption";
    private static final String ENCRYPTION_CONFIG_PATH = ConfigUtil.joinPath((String[])new String[]{"ignite", "encryption"});
    private final EncryptionView encryptionView;

    private EncryptionConfig(EncryptionView encryptionView) {
        this.encryptionView = encryptionView;
    }

    static EncryptionConfig fromHoconString(String hoconCfg, Supplier<SuperRoot> superRootFactory) {
        Config config = ConfigFactory.parseString((String)hoconCfg);
        ConfigurationSource configurationSource = config.hasPath(ENCRYPTION_CONFIG_PATH) ? HoconConverter.hoconSource((ConfigObject)config.getObject(ENCRYPTION_CONFIG_PATH)) : ConfigurationUtil.EMPTY_CFG_SRC;
        SuperRoot sr = superRootFactory.get();
        InnerNode encryptionExtensionNode = sr.getRoot(EncryptionExtensionConfiguration.KEY);
        assert (encryptionExtensionNode != null);
        encryptionExtensionNode.construct(ENCRYPTION_CONFIG_NAME, configurationSource, true);
        EncryptionView encryptionView = ((EncryptionExtensionView)encryptionExtensionNode).encryption();
        ConfigurationUtil.addDefaults((InnerNode)((InnerNode)encryptionView));
        return new EncryptionConfig(encryptionView);
    }

    static EncryptionConfig fromConfig(EncryptionView config) {
        return new EncryptionConfig(config);
    }

    String toHoconString() {
        ConverterToMapVisitor visitor = ConverterToMapVisitor.builder().includeInternal(true).maskSecretValues(false).build();
        return HoconConverter.represent((TraversableTreeNode)((InnerNode)this.encryptionView), List.of(), (ConfigurationVisitor)visitor).atPath(ENCRYPTION_CONFIG_PATH).root().render(ConfigRenderOptions.concise());
    }

    EncryptionView encryptionView() {
        return this.encryptionView;
    }
}

