/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.provider.secret;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.provider.KeyProvider;
import org.gridgain.internal.encryption.utils.EncryptionUtils;

public class SecretPhraseKeyProvider
implements KeyProvider {
    private static final Random RANDOM_INSTANCE = new SecureRandom();
    private static final String KEY_DERIVATION_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final String KEY_ALGORITHM = "AES";
    private static final int ITERATION_COUNT = 65536;
    private static final int KEY_LENGTH = 256;
    private static final String DEFAULT_KEY_IDENTIFIER = "secret.key";
    private final String providerName;
    private final Key key;
    private final Cipher cipher;

    private SecretPhraseKeyProvider(String providerName, Key key, Cipher cipher) {
        this.providerName = providerName;
        this.key = key;
        this.cipher = cipher;
    }

    public byte[] encryptKey(DataEncryptionKey dataKey) {
        return EncryptionUtils.encryptKey(RANDOM_INSTANCE, dataKey, this.key, this.cipher.getAlgorithm());
    }

    public DataEncryptionKey decryptKey(byte[] data, String ignored) {
        return EncryptionUtils.decryptKey(data, this.key, this.cipher.getAlgorithm());
    }

    public String getProviderIdentifier() {
        return this.providerName;
    }

    public String getActiveKeyIdentifier() {
        return DEFAULT_KEY_IDENTIFIER;
    }

    public static SecretPhraseKeyProvider create(String providerName, String secretPhrase, String salt, Cipher cipher) {
        SecretPhraseKeyProvider secretPhraseKeyProvider;
        char[] secretPhraseArr = null;
        byte[] saltArr = null;
        try {
            secretPhraseArr = secretPhrase.toCharArray();
            saltArr = salt.getBytes(StandardCharsets.UTF_8);
            PBEKeySpec keySpec = new PBEKeySpec(secretPhraseArr, saltArr, 65536, 256);
            SecretKey pbeKey = SecretKeyFactory.getInstance(KEY_DERIVATION_ALGORITHM).generateSecret(keySpec);
            SecretKeySpec key = new SecretKeySpec(pbeKey.getEncoded(), KEY_ALGORITHM);
            secretPhraseKeyProvider = new SecretPhraseKeyProvider(providerName, key, cipher);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptionUtils.clear(secretPhraseArr);
                EncryptionUtils.clear(saltArr);
                throw throwable;
            }
        }
        EncryptionUtils.clear(secretPhraseArr);
        EncryptionUtils.clear(saltArr);
        return secretPhraseKeyProvider;
    }
}

