/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.storage;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.gridgain.internal.encryption.DataEncryptionKeyNotFoundException;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.event.EncryptionEvent;
import org.gridgain.internal.encryption.event.EncryptionEventParameters;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.gridgain.internal.encryption.storage.DataEncryptionKeyManager;
import org.gridgain.internal.encryption.storage.KeyChain;
import org.gridgain.internal.encryption.storage.KeyStorage;
import org.jetbrains.annotations.Nullable;

public class DataEncryptionKeyManagerImpl
implements DataEncryptionKeyManager,
IgniteComponent,
EventListener<EncryptionEventParameters> {
    private static final IgniteLogger LOG = Loggers.forClass(DataEncryptionKeyManagerImpl.class);
    private final Map<String, KeyChain> keysByChainId = new ConcurrentHashMap<String, KeyChain>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final FailureProcessor failureProcessor;
    private final EncryptionManager encryptionManager;
    private final KeyStorage storage;

    public DataEncryptionKeyManagerImpl(KeyStorage storage, EncryptionManager encryptionManager, FailureProcessor failureProcessor) {
        this.storage = storage;
        this.failureProcessor = failureProcessor;
        this.encryptionManager = encryptionManager;
    }

    @Override
    public DataEncryptionKey activeKey(String chainId) {
        KeyChain chain = this.keysByChainId.get(chainId);
        if (chain == null) {
            throw new DataEncryptionKeyNotFoundException(chainId);
        }
        return chain.activeKey();
    }

    @Override
    public DataEncryptionKey getKey(String chainId, int keyId) {
        KeyChain chain = this.keysByChainId.get(chainId);
        if (chain == null) {
            throw new DataEncryptionKeyNotFoundException(chainId, keyId);
        }
        DataEncryptionKey key = chain.getKey(keyId);
        if (key == null) {
            throw new DataEncryptionKeyNotFoundException(chainId, keyId);
        }
        return key;
    }

    @Override
    public boolean keyChainExists(String chainId) {
        return this.keysByChainId.containsKey(chainId);
    }

    @Override
    public boolean createKeyChain(String chainId, DataEncryptionKey key, @Nullable String providerName) {
        return (Boolean)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.keysByChainId.computeIfAbsent(chainId, id -> {
            KeyChain result = new KeyChain(key, providerName);
            this.storage.store(chainId, result);
            return result;
        }).activeKey() == key);
    }

    @Override
    public void addKey(String chainId, DataEncryptionKey newKey) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            KeyChain chain = this.keysByChainId.get(chainId);
            if (chain == null) {
                throw new DataEncryptionKeyNotFoundException(chainId);
            }
            chain.addKey(newKey);
        });
    }

    @Override
    public void changeActiveKey(String chainId, int keyId) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            KeyChain chain = this.keysByChainId.get(chainId);
            if (chain == null) {
                throw new DataEncryptionKeyNotFoundException(chainId, keyId);
            }
            if (!chain.changeActiveKey(keyId)) {
                throw new DataEncryptionKeyNotFoundException(chainId, keyId);
            }
        });
    }

    @Override
    public void remove(String chainId) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            this.keysByChainId.computeIfPresent(chainId, (id, chain) -> {
                this.storage.remove((String)id);
                return null;
            });
            LOG.debug("Key(s) removed. [tableId=" + chainId + "]", new Object[0]);
        });
    }

    private void doChangeMasterKey() {
        LOG.info("Start master key change", new Object[0]);
        try {
            IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.storage.storeAll(this.keysByChainId));
            LOG.info("Master key successfully changed", new Object[0]);
        }
        catch (Exception e) {
            this.failureProcessor.process(new FailureContext((Throwable)e, "Unable to change master key locally."));
        }
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        Map<String, KeyChain> keyChains = this.storage.getKeyChains();
        this.keysByChainId.putAll(keyChains);
        this.storage.storeAll(keyChains);
        this.encryptionManager.listen((Event)EncryptionEvent.ACTIVE_PROVIDER_UPDATED, (EventListener)this);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.encryptionManager.removeListener((Event)EncryptionEvent.ACTIVE_PROVIDER_UPDATED, (EventListener)this);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Boolean> notify(EncryptionEventParameters parameters) {
        if (parameters.type() == EncryptionEvent.ACTIVE_PROVIDER_UPDATED) {
            this.doChangeMasterKey();
        }
        return CompletableFutures.falseCompletedFuture();
    }
}

