/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.events.BeforeStartRaftGroupEventParameters;
import org.apache.ignite.internal.cluster.management.events.ClusterManagerGroupEvent;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;
import org.gridgain.internal.encryption.EncryptionConfig;
import org.gridgain.internal.encryption.EncryptionManagerImpl;
import org.gridgain.internal.encryption.configuration.EncryptionConfiguration;
import org.gridgain.internal.encryption.configuration.EncryptionView;
import org.jetbrains.annotations.Nullable;

public class EncryptionConfigurationVault
implements IgniteComponent {
    private static final ByteArray CMG_ENCRYPTION_VAULT_KEY = ByteArray.fromString((String)"cmg_encryption_cfg");
    private final EncryptionManagerImpl encryptionManager;
    private final VaultManager vaultManager;
    private final Supplier<SuperRoot> clusterCfgSuperRootFactory;
    private final ClusterManagementGroupManager cmgMgr;
    private final IgniteComponent logStorageFactory;
    private final Executor ioExecutor;
    private final EncryptionConfiguration encryptionConfiguration;

    public EncryptionConfigurationVault(EncryptionManagerImpl encryptionManager, VaultManager vaultManager, Supplier<SuperRoot> clusterCfgSuperRootFactory, ClusterManagementGroupManager cmgMgr, IgniteComponent logStorageFactory, Executor ioExecutor, EncryptionConfiguration encryptionConfiguration) {
        this.encryptionManager = encryptionManager;
        this.vaultManager = vaultManager;
        this.clusterCfgSuperRootFactory = clusterCfgSuperRootFactory;
        this.cmgMgr = cmgMgr;
        this.logStorageFactory = logStorageFactory;
        this.ioExecutor = ioExecutor;
        this.encryptionConfiguration = encryptionConfiguration;
    }

    private void init(@Nullable String initialClusterConfig) {
        if (initialClusterConfig == null) {
            EncryptionConfig encryptionConfig = this.loadEncryptionConfig();
            if (encryptionConfig != null) {
                this.initEncryptionConfigOnRecovery(encryptionConfig);
            }
        } else {
            this.initEncryptionConfig(initialClusterConfig);
        }
    }

    private void registerConfigListener() {
        this.encryptionConfiguration.listen(ctx -> {
            EncryptionView encryptionView = (EncryptionView)ctx.newValue(EncryptionView.class);
            assert (encryptionView != null);
            this.saveEncryptionConfig(encryptionView);
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private void initEncryptionConfig(String hoconConfig) {
        EncryptionConfig config = EncryptionConfig.fromHoconString(hoconConfig, this.clusterCfgSuperRootFactory);
        this.encryptionManager.init(config.encryptionView());
        this.saveEncryptionConfig(config);
    }

    private void initEncryptionConfigOnRecovery(EncryptionConfig config) {
        this.encryptionManager.initOnRecovery(config.encryptionView());
    }

    public void saveCurrentEncryptionConfig() {
        this.saveEncryptionConfig((EncryptionView)this.encryptionConfiguration.value());
    }

    private void saveEncryptionConfig(EncryptionView config) {
        this.saveEncryptionConfig(EncryptionConfig.fromConfig(config));
    }

    private void saveEncryptionConfig(EncryptionConfig config) {
        byte[] data = ByteUtils.stringToBytes((String)config.toHoconString());
        this.vaultManager.put(CMG_ENCRYPTION_VAULT_KEY, data);
    }

    @Nullable
    private EncryptionConfig loadEncryptionConfig() {
        VaultEntry entry = this.vaultManager.get(CMG_ENCRYPTION_VAULT_KEY);
        if (entry == null) {
            return null;
        }
        String hoconString = ByteUtils.stringFromBytes((byte[])entry.value());
        return EncryptionConfig.fromHoconString(hoconString, this.clusterCfgSuperRootFactory);
    }

    private void clearState() {
        this.vaultManager.remove(CMG_ENCRYPTION_VAULT_KEY);
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.registerConfigListener();
        this.cmgMgr.listen((Event)ClusterManagerGroupEvent.BEFORE_START_RAFT_GROUP, evt -> {
            BeforeStartRaftGroupEventParameters params = (BeforeStartRaftGroupEventParameters)evt;
            try {
                this.init(params.initialClusterConfig());
            }
            catch (RuntimeException ex) {
                return CompletableFuture.failedFuture(ex);
            }
            return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.logStorageFactory.startAsync(componentContext), this.ioExecutor).thenCompose(Function.identity())).thenApply(none -> false);
        });
        this.cmgMgr.listen((Event)ClusterManagerGroupEvent.BEFORE_DESTROY_RAFT_GROUP, none -> {
            this.clearState();
            return CompletableFutures.falseCompletedFuture();
        });
        this.cmgMgr.listen((Event)ClusterManagerGroupEvent.AFTER_STOP_RAFT_GROUP, none -> this.logStorageFactory.stopAsync(componentContext).thenApply(other -> false));
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }
}

