/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption;

import java.io.IOException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;

public class DataEncryptionKeySerializer
extends VersionedSerializer<DataEncryptionKey> {
    public static final DataEncryptionKeySerializer INSTANCE = new DataEncryptionKeySerializer();
    private static final String FORMAT_RAW = "RAW";

    public static byte[] serialize(DataEncryptionKey key) {
        return VersionedSerialization.toBytes((Object)key, (VersionedSerializer)INSTANCE);
    }

    public static DataEncryptionKey deserialize(byte[] bytes) {
        return (DataEncryptionKey)VersionedSerialization.fromBytesIgnoringLeftovers((byte[])bytes, (VersionedSerializer)INSTANCE);
    }

    protected void writeExternalData(DataEncryptionKey key, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)key.id());
        DataEncryptionKeySerializer.writeSecretKey(key.key(), out);
    }

    private static void writeSecretKey(SecretKey key, IgniteDataOutput out) throws IOException {
        assert (FORMAT_RAW.equals(key.getFormat())) : "Actual format is " + key.getFormat();
        out.writeUTF(key.getAlgorithm());
        DataEncryptionKeySerializer.writeByteArrayWithLength((byte[])key.getEncoded(), (IgniteDataOutput)out);
    }

    protected DataEncryptionKey readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int id = in.readVarIntAsInt();
        SecretKey key = DataEncryptionKeySerializer.readSecretKey(in);
        return new DataEncryptionKey(id, key);
    }

    private static SecretKey readSecretKey(IgniteDataInput in) throws IOException {
        String algorithm = in.readUTF();
        byte[] encoded = DataEncryptionKeySerializer.readByteArrayWithLength((IgniteDataInput)in);
        return new SecretKeySpec(encoded, algorithm);
    }
}

