/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.jetbrains.annotations.Nullable;

public class KeyChain {
    private final Map<Integer, DataEncryptionKey> keys = new ConcurrentHashMap<Integer, DataEncryptionKey>();
    private int activeKeyId;
    @Nullable
    private final String providerName;

    public KeyChain(DataEncryptionKey key, @Nullable String providerName) {
        this.activeKeyId = key.id();
        this.keys.put(key.id(), key);
        this.providerName = providerName;
    }

    public KeyChain(int activeKeyId, Collection<DataEncryptionKey> keys, @Nullable String providerName) {
        this.activeKeyId = activeKeyId;
        this.keys.putAll(keys.stream().collect(Collectors.toMap(DataEncryptionKey::id, Function.identity())));
        this.providerName = providerName;
    }

    @Nullable
    public String providerName() {
        return this.providerName;
    }

    public Collection<DataEncryptionKey> keys() {
        return Collections.unmodifiableCollection(this.keys.values());
    }

    public DataEncryptionKey activeKey() {
        return this.keys.get(this.activeKeyId);
    }

    public DataEncryptionKey getKey(int keyId) {
        return this.keys.get(keyId);
    }

    public void addKey(DataEncryptionKey key) {
        this.keys.put(key.id(), key);
    }

    public boolean changeActiveKey(int keyId) {
        if (!this.keys.containsKey(keyId)) {
            return false;
        }
        this.activeKeyId = keyId;
        return true;
    }
}

