/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.validator;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.util.StringUtils;
import org.gridgain.internal.encryption.configuration.EncryptionView;
import org.gridgain.internal.encryption.provider.configuration.KeyProviderView;
import org.gridgain.internal.encryption.utils.KeyProviderValidationUtils;
import org.gridgain.internal.encryption.validator.KeyProviderValidator;

public class KeyProviderValidatorImpl
implements Validator<KeyProviderValidator, NamedListView<? extends KeyProviderView>> {
    public static final KeyProviderValidatorImpl INSTANCE = new KeyProviderValidatorImpl();

    public void validate(KeyProviderValidator annotation, ValidationContext<NamedListView<? extends KeyProviderView>> ctx) {
        String activeProvider;
        NamedListView view = (NamedListView)ctx.getNewValue();
        EncryptionView encryptionView = (EncryptionView)ctx.getNewOwner();
        boolean enabled = encryptionView.enabled();
        if (enabled && view.isEmpty()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "At least one provider is required."));
        }
        if (!StringUtils.nullOrBlank((String)(activeProvider = KeyProviderValidationUtils.normalizeProviderName(encryptionView.activeProvider()))) && view.stream().noneMatch(s -> activeProvider.equals(KeyProviderValidationUtils.normalizeProviderName(s.name())))) {
            String message = "Provider \"" + activeProvider + "\" is not present in the provider configuration";
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        }
        for (KeyProviderView i : view) {
            String message;
            try {
                Cipher.getInstance(i.cipher());
            }
            catch (NoSuchAlgorithmException e) {
                message = "Cipher algorithm \"" + i.cipher() + "\" is not supported: " + e.getMessage();
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
            }
            catch (NoSuchPaddingException e) {
                message = "Cipher padding \"" + i.cipher() + "\" is not supported: " + e.getMessage();
                ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
            }
        }
    }
}

