/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.validator;

import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.gridgain.internal.encryption.validator.Size;

public class SizeValidator
implements Validator<Size, String> {
    public static final SizeValidator INSTANCE = new SizeValidator();

    public void validate(Size annotation, ValidationContext<String> ctx) {
        String newValue = (String)ctx.getNewValue();
        if (newValue == null) {
            return;
        }
        long sz = newValue.length();
        if (sz < (long)annotation.min()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Size of configuration value '" + ctx.currentKey() + "' must not be less than " + annotation.min() + "."));
        }
        if (sz > (long)annotation.max()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Size of configuration value '" + ctx.currentKey() + "' must not be greater than " + annotation.max() + "."));
        }
    }
}

