/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.properties.IgniteProperties;

public class DrReceiverSystemInfoPrinter {
    private static final String BANNER = System.lineSeparator() + "  _________        _____ __________________        _____" + System.lineSeparator() + "  __  ____/___________(_)______  /__  ____/______ ____(_)_______" + System.lineSeparator() + "  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \\" + System.lineSeparator() + "  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /" + System.lineSeparator() + "  \\____/   /_/     /_/   \\_,__/   \\____/   \\__,_/  /_/   /_/ /_/";

    public static void print(IgniteLogger logger) {
        String jvmPid;
        String padding = " ".repeat(22);
        String version = IgniteProperties.get((String)"ignite.version");
        String commitHash = IgniteProperties.get((String)"ignite.release.commit");
        try {
            jvmPid = String.valueOf(ProcessHandle.current().pid());
        }
        catch (Throwable ignore) {
            jvmPid = "N/A";
        }
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String osUser = System.getProperty("user.name");
        String jreName = System.getProperty("java.runtime.name");
        String jreVersion = System.getProperty("java.runtime.version");
        String jvmVendor = System.getProperty("java.vm.vendor");
        String jvmName = System.getProperty("java.vm.name");
        String jvmVersion = System.getProperty("java.vm.version");
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        String gcConfiguration = gcBeans.stream().map(MemoryManagerMXBean::getName).collect(Collectors.joining(", "));
        logger.info("{}" + System.lineSeparator() + "{}{}" + System.lineSeparator(), new Object[]{BANNER, padding, "GridGain DR connector version " + version + "-sha1:" + commitHash});
        logger.info("Available processors: {}", new Object[]{Runtime.getRuntime().availableProcessors()});
        logger.info("OS: [name={}, version={}, arch={}, user={}, pid={}]", new Object[]{osName, osVersion, osArch, osUser, jvmPid});
        logger.info("VM: [jreName={}, jreVersion={}, jvmVendor={}, jvmName={}, jvmVersion={}]", new Object[]{jreName, jreVersion, jvmVendor, jvmName, jvmVersion});
        logger.info("VM arguments: {}", new Object[]{String.join((CharSequence)" ", runtimeMxBean.getInputArguments())});
        logger.info("VM Memory Configuration: heap [init={}, max={}]", new Object[]{DrReceiverSystemInfoPrinter.humanReadableSize(heapMemoryUsage.getInit()), DrReceiverSystemInfoPrinter.humanReadableSize(heapMemoryUsage.getMax())});
        logger.info("VM GC: {}", new Object[]{gcConfiguration});
    }

    private static String humanReadableSize(long bytes) {
        String[] suffix = new String[]{"KB", "MB", "GB", "TB"};
        for (int i = suffix.length; i > 0; --i) {
            int shift = i * 10;
            long valueInUnits = bytes >> shift;
            if (valueInUnits <= 0L) continue;
            return valueInUnits + " " + suffix[i - 1];
        }
        return bytes + " B";
    }
}

