/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.tostring.S;
import org.gridgain.internal.dr.DrUtils;
import org.gridgain.internal.dr.messages.DrExternalMessage;
import org.gridgain.internal.dr.nio.DrNioMessageMarshaller;

public class DrNioHandler
extends ByteToMessageCodec<DrExternalMessage> {
    private final DrNioMessageMarshaller marshaller;

    public DrNioHandler(DrNioMessageMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    protected void encode(ChannelHandlerContext ctx, DrExternalMessage msg, ByteBuf out) {
        ByteBuffer data = this.marshaller.marshal(msg);
        out.writeBytes(data);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        ByteBuffer bb = in.nioBuffer();
        int length = bb.remaining();
        Object message = this.marshaller.unmarshal(bb.order(DrUtils.DR_BYTE_ORDER));
        if (message != null) {
            in.skipBytes(length);
            out.add(message);
        }
    }

    public String toString() {
        return S.toString(DrNioHandler.class, (Object)((Object)this));
    }
}

