/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.common;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.lang.IgniteStringFormatter;

public class GridCacheVersion
implements Externalizable,
Comparable<GridCacheVersion> {
    private static final long serialVersionUID = 0L;
    private static final int NODE_ORDER_MASK = 0x7FFFFFF;
    private static final int DR_ID_SHIFT = 27;
    private static final int DR_ID_MASK = 31;
    private int topVer;
    private int nodeOrderDrId;
    protected long order;
    private long updateCounter;

    public GridCacheVersion() {
    }

    public GridCacheVersion(int topVer, long order, int nodeOrder, int dataCenterId) {
        assert (topVer >= 0) : topVer;
        assert (order >= 0L) : order;
        assert (nodeOrder >= 0) : nodeOrder;
        assert (dataCenterId < 32 && dataCenterId >= 0) : dataCenterId;
        if (nodeOrder > 0x7FFFFFF) {
            throw new IllegalArgumentException("Node order overflow: " + nodeOrder);
        }
        this.topVer = topVer;
        this.order = order;
        this.nodeOrderDrId = nodeOrder | dataCenterId << 27;
    }

    public int topologyVersion() {
        return this.topVer;
    }

    public long order() {
        return this.order;
    }

    public int nodeOrder() {
        return this.nodeOrderDrId & 0x7FFFFFF;
    }

    public byte dataCenterId() {
        return (byte)(this.nodeOrderDrId >> 27 & 0x1F);
    }

    public long updateCounter() {
        return this.updateCounter;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternalV1(out);
        this.writeExternalV2(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternalV1(in);
        this.readExternalV2(in);
    }

    protected void writeExternalV1(ObjectOutput out) throws IOException {
        out.writeInt(this.topVer);
        out.writeLong(this.order);
        out.writeInt(this.nodeOrderDrId);
    }

    protected void readExternalV1(ObjectInput in) throws IOException {
        this.topVer = in.readInt();
        this.order = in.readLong();
        this.nodeOrderDrId = in.readInt();
    }

    protected void writeExternalV2(ObjectOutput out) throws IOException {
        out.writeLong(this.updateCounter);
    }

    protected void readExternalV2(ObjectInput in) throws IOException {
        try {
            this.updateCounter = in.readLong();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GridCacheVersion)) {
            return false;
        }
        GridCacheVersion that = (GridCacheVersion)o;
        return this.topVer == that.topVer && this.order == that.order && this.nodeOrder() == that.nodeOrder();
    }

    public int hashCode() {
        int res = this.topVer;
        res = 31 * res + this.nodeOrder();
        res = 31 * res + (int)(this.order ^ this.order >>> 32);
        return res;
    }

    @Override
    public int compareTo(GridCacheVersion other) {
        int res = Integer.compare(this.topologyVersion(), other.topologyVersion());
        if (res != 0) {
            return res;
        }
        res = Long.compare(this.order(), other.order());
        if (res != 0) {
            return res;
        }
        return Integer.compare(this.nodeOrder(), other.nodeOrder());
    }

    public String toString() {
        return IgniteStringFormatter.format((String)"GridCacheVersion [dcId={}, topVer={}, order={}, nodeOrder={}]", (Object[])new Object[]{this.dataCenterId(), this.topVer, this.order, this.nodeOrder()});
    }
}

