/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.configuration.SslView;
import org.apache.ignite.internal.network.ssl.SslContextProvider;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.gridgain.dr.configuration.DrReceiverServerView;
import org.gridgain.internal.dr.DrUtils;
import org.gridgain.internal.dr.nio.DrNioHandler;
import org.gridgain.internal.dr.nio.DrNioMessageDecoder;
import org.gridgain.internal.dr.nio.DrNioMessageMarshaller;
import org.gridgain.internal.dr.nio.IdleChannelHandler;
import org.jetbrains.annotations.Nullable;

public class DrReceiverServer {
    private static final IgniteLogger LOG = Loggers.forClass(DrReceiverServer.class);
    private static final String INSTANCE_NAME = "gridgain-dr-service";
    private final DrReceiverServerView cfg;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ChannelInboundHandler handler;
    private volatile Channel channel;
    private NioEventLoopGroup boss;
    private NioEventLoopGroup worker;

    public DrReceiverServer(DrReceiverServerView cfg, ChannelInboundHandler handler) {
        this.cfg = Objects.requireNonNull(cfg);
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            DrReceiverServer.validateReceiverConfiguration(this.cfg);
            this.boss = new NioEventLoopGroup(this.cfg.selectorCnt(), (ThreadFactory)NamedThreadFactory.create((String)INSTANCE_NAME, (String)"receiver-nio-acceptor", (IgniteLogger)LOG));
            this.worker = new NioEventLoopGroup(this.cfg.workerThreads(), (ThreadFactory)NamedThreadFactory.create((String)INSTANCE_NAME, (String)"receiver-nio-worker", (IgniteLogger)LOG));
            ServerBootstrap bootstrap = this.createServerBootStrap(this.cfg);
            final @Nullable SslContext sslContext = this.cfg.ssl().enabled() ? SslContextProvider.createServerSslContext((SslView)this.cfg.ssl()) : null;
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (DrReceiverServer.this.cfg.ssl().enabled()) {
                        SSLEngine sslEngine = sslContext.newEngine(ByteBufAllocator.DEFAULT);
                        sslEngine.setUseClientMode(false);
                        pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine, false));
                    }
                    if (LOG.isTraceEnabled()) {
                        pipeline.addLast(new ChannelHandler[]{new LoggingHandler("child-logger", LogLevel.TRACE)});
                    }
                    if (DrReceiverServer.this.cfg.idleTimeout() > 0 || DrReceiverServer.this.cfg.writeTimeout() > 0L) {
                        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler((long)DrReceiverServer.this.cfg.idleTimeout(), DrReceiverServer.this.cfg.writeTimeout(), 0L, TimeUnit.MILLISECONDS)});
                        pipeline.addLast(new ChannelHandler[]{new IdleChannelHandler(DrReceiverServer.this.cfg.idleTimeout())});
                    }
                    pipeline.addLast("dr-nio-codec", (ChannelHandler)new DrNioMessageDecoder()).addLast("dr-msg-codec", (ChannelHandler)new DrNioHandler(new DrNioMessageMarshaller())).addLast("dr-msg-handler", (ChannelHandler)DrReceiverServer.this.handler);
                }
            });
            InetAddress localHostAddress = DrUtils.toInetAddress(this.cfg.inboundHost());
            int localInboundPort = this.cfg.inboundPort();
            try {
                this.tryBind(bootstrap, localHostAddress, localInboundPort).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, ExceptionUtils.unwrapCause((Throwable)ex));
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void stop() {
        LOG.info("Stopping a DR receiver hub.", new Object[0]);
        this.busyLock.block();
        if (this.channel != null) {
            this.channel.close().syncUninterruptibly();
        }
        if (this.boss != null) {
            this.boss.shutdownGracefully(0L, 15L, TimeUnit.SECONDS).syncUninterruptibly();
        }
        if (this.worker != null) {
            this.worker.shutdownGracefully(0L, 15L, TimeUnit.SECONDS).syncUninterruptibly();
        }
    }

    private CompletableFuture<Void> tryBind(ServerBootstrap bootstrap, InetAddress host, int port) {
        return this.tryBind0(bootstrap, host, port, new CompletableFuture<Void>());
    }

    private CompletableFuture<Void> tryBind0(ServerBootstrap bootstrap, InetAddress host, int port, CompletableFuture<Void> resultFuture) {
        ChannelFuture bindFuture = bootstrap.validate().bind(host, port);
        bindFuture.addListener(future -> {
            if (!this.busyLock.enterBusy()) {
                if (future.isDone()) {
                    bindFuture.channel().close();
                }
                resultFuture.complete(null);
                return;
            }
            try {
                if (future.isSuccess()) {
                    LOG.info("Listening port: host={}, port={}", new Object[]{host, port});
                    this.channel = bindFuture.channel();
                    resultFuture.complete(null);
                } else if (future.isDone()) {
                    Throwable cause = future.cause();
                    LOG.error("Port binding failed: host={}, port={}", cause, new Object[]{host, port});
                    bindFuture.channel().close();
                    resultFuture.completeExceptionally(cause);
                } else {
                    LOG.info("Retry port binding (port is busy?): host={}, port={}", new Object[]{host, port});
                    this.tryBind0(bootstrap, host, port, resultFuture);
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        });
        return resultFuture;
    }

    private ServerBootstrap createServerBootStrap(DrReceiverServerView cfg) {
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.boss, (EventLoopGroup)this.worker).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.TCP_NODELAY, (Object)cfg.tcpNodelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)cfg.idleTimeout());
        if (LOG.isTraceEnabled()) {
            bootstrap.handler((ChannelHandler)new LoggingHandler("acceptor-logger", LogLevel.TRACE));
        }
        if (cfg.socketReceiveBufferSize() > 0) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)cfg.socketReceiveBufferSize());
        }
        if (cfg.socketSendBufferSize() > 0) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)cfg.socketSendBufferSize());
        }
        return bootstrap;
    }

    private static void validateReceiverConfiguration(DrReceiverServerView cfg) {
        if (!StringUtils.nullOrEmpty((String)cfg.inboundHost())) {
            try {
                InetAddress.getByName(cfg.inboundHost());
            }
            catch (UnknownHostException ignore) {
                throw new IgniteException(ErrorGroups.Common.ILLEGAL_ARGUMENT_ERR, "Configuration parameter 'localInboundHost' cannot be resolved to local address.");
            }
        }
    }
}

