/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ml.model;

import java.util.Map;
import org.apache.ignite.marshalling.Marshaller;
import org.gridgain.ml.model.MlJobParameters;
import org.gridgain.ml.model.ModelConfig;
import org.gridgain.ml.model.ModelInfo;

public class MlSimpleJobParameters<I>
extends MlJobParameters {
    private static final long serialVersionUID = 1L;
    private I input;

    protected MlSimpleJobParameters(Builder<I> builder) {
        super(builder);
        this.input = builder.input;
    }

    public I input() {
        return this.input;
    }

    public void setInput(I input) {
        this.input = input;
    }

    @Override
    protected void validateOperationSpecific() {
        if (this.input == null) {
            throw new IllegalStateException("Input is required for PREDICT operation");
        }
    }

    public static <I> Builder<I> builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "MlSimpleJobParameters{modelId='" + this.id() + "', modelName='" + this.name() + "', version='" + this.version() + "', type=" + this.type() + ", url='" + this.url() + "', operationType=" + this.operationType() + ", input=" + this.input + ", hasCustomComponents=" + this.hasCustomComponents() + (String)(this.customJobClass() != null ? ", customJobClass=" + this.customJobClass().getName() : "") + (String)(this.customInputMarshaller() != null ? ", customInputMarshaller=" + this.customInputMarshaller().getClass().getName() : "") + (String)(this.customOutputMarshaller() != null ? ", customOutputMarshaller=" + this.customOutputMarshaller().getClass().getName() : "") + "}";
    }

    public static class Builder<I>
    extends MlJobParameters.Builder {
        private I input;

        public Builder() {
            this.operationType = MlJobParameters.OperationType.PREDICT;
        }

        public Builder<I> input(I input) {
            this.input = input;
            return this;
        }

        @Override
        public Builder<I> id(String id) {
            super.id(id);
            return this;
        }

        @Override
        public Builder<I> name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder<I> version(String version) {
            super.version(version);
            return this;
        }

        @Override
        public Builder<I> url(String url) {
            super.url(url);
            return this;
        }

        @Override
        public Builder<I> config(ModelConfig config) {
            super.config(config);
            return this;
        }

        @Override
        public Builder<I> addProperty(String key, String value) {
            super.addProperty(key, value);
            return this;
        }

        @Override
        public Builder<I> property(String key, String value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder<I> properties(Map<String, String> properties) {
            super.properties((Map)properties);
            return this;
        }

        @Override
        public Builder<I> loaded(boolean loaded) {
            super.loaded(loaded);
            return this;
        }

        @Override
        public Builder<I> loadTimestamp(long loadTimestamp) {
            super.loadTimestamp(loadTimestamp);
            return this;
        }

        @Override
        public Builder<I> status(ModelInfo.ModelStatus status) {
            super.status(status);
            return this;
        }

        @Override
        public Builder<I> from(ModelInfo modelInfo) {
            super.from(modelInfo);
            return this;
        }

        @Override
        public Builder<I> operationType(MlJobParameters.OperationType operationType) {
            super.operationType(operationType);
            return this;
        }

        @Override
        public Builder<I> customJobClass(Class customJobClass) {
            super.customJobClass(customJobClass);
            return this;
        }

        @Override
        public Builder<I> customInputMarshaller(Marshaller<?, byte[]> customInputMarshaller) {
            super.customInputMarshaller(customInputMarshaller);
            return this;
        }

        @Override
        public Builder<I> customOutputMarshaller(Marshaller<?, byte[]> customOutputMarshaller) {
            super.customOutputMarshaller(customOutputMarshaller);
            return this;
        }

        @Override
        public Builder<I> inputClass(String inputClass) {
            super.inputClass(inputClass);
            return this;
        }

        @Override
        public Builder<I> outputClass(String outputClass) {
            super.outputClass(outputClass);
            return this;
        }

        @Override
        public Builder<I> translator(String translator) {
            super.translator(translator);
            return this;
        }

        @Override
        public Builder<I> translatorFactory(String translatorFactory) {
            super.translatorFactory(translatorFactory);
            return this;
        }

        @Override
        public MlSimpleJobParameters<I> build() {
            MlSimpleJobParameters params = new MlSimpleJobParameters(this);
            params.validate();
            return params;
        }
    }
}

