/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ml.compute;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.deployment.DeploymentUnitInfo;
import org.apache.ignite.marshalling.Marshaller;
import org.gridgain.ml.DeploymentException;
import org.gridgain.ml.compute.MlInputMarshaller;
import org.gridgain.ml.model.MlJobParameters;
import org.jetbrains.annotations.Nullable;

public abstract class MlComputeJob<I extends MlJobParameters, O>
implements ComputeJob<I, O> {
    @Override
    @Nullable
    public Marshaller<I, byte[]> inputMarshaller() {
        return new MlInputMarshaller();
    }

    public abstract CompletableFuture<O> predictAsync(JobExecutionContext var1, @Nullable I var2);

    @Override
    public CompletableFuture<O> executeAsync(JobExecutionContext context, @Nullable I arg) {
        this.updateModelPathFromDeploymentUnits((MlJobParameters)arg, context.deploymentUnits());
        return this.predictAsync(context, arg);
    }

    protected void updateModelPathFromDeploymentUnits(MlJobParameters jobParameters, Collection<DeploymentUnitInfo> deploymentUnitInfo) {
        if (deploymentUnitInfo.size() > 1) {
            throw new DeploymentException("ML requires a single deployment unit, but " + deploymentUnitInfo.size() + " were provided ", null);
        }
        if (!deploymentUnitInfo.isEmpty()) {
            Path modelPath = Paths.get(deploymentUnitInfo.iterator().next().path().toString(), new String[0]);
            String modelUrl = modelPath.toString();
            jobParameters.setUrl(modelUrl);
        }
        jobParameters.customJobClass(this.getClass());
        jobParameters.customInputMarshaller(this.inputMarshaller());
        jobParameters.customOutputMarshaller(this.resultMarshaller());
    }
}

