/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.reencryption;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.tostring.S;

public class ReencryptionStatus {
    private final Map<Integer, Integer> partitionToIndex = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> partitionToPageCount = new HashMap<Integer, Integer>();
    private State state;
    private final int keyId;

    public ReencryptionStatus(int keyId, State state) {
        this.keyId = keyId;
        this.state = state;
    }

    public ReencryptionStatus(Map<Integer, Integer> partitionToIndex, Map<Integer, Integer> partitionToPageCount, State state, int keyId) {
        this.partitionToIndex.putAll(partitionToIndex);
        this.partitionToPageCount.putAll(partitionToPageCount);
        this.keyId = keyId;
        this.state = state;
    }

    public void updateProgress(int partitionId, int lastProcessedPageIndex) {
        this.partitionToIndex.put(partitionId, lastProcessedPageIndex);
    }

    public void updateCount(int partitionId, int pageCount) {
        this.partitionToPageCount.put(partitionId, pageCount);
    }

    public int keyId() {
        return this.keyId;
    }

    public int lastProcessedPageIndex(int partitionId) {
        Integer index = this.partitionToIndex.get(partitionId);
        if (index == null) {
            return 0;
        }
        return index;
    }

    public int pageCount(int partitionId) {
        Integer pageCount = this.partitionToPageCount.get(partitionId);
        if (pageCount == null) {
            return -1;
        }
        return pageCount;
    }

    public State state() {
        return this.state;
    }

    public void updateState(State state) {
        this.state = state;
    }

    public Map<Integer, Integer> partitionToIndex() {
        return Collections.unmodifiableMap(this.partitionToIndex);
    }

    public Map<Integer, Integer> partitionToPageCount() {
        return Collections.unmodifiableMap(this.partitionToPageCount);
    }

    public String toString() {
        return S.toString(this);
    }

    public static enum State {
        IN_PROGRESS,
        COMPLETED,
        CANCELED_DUE_TO_NEW_REENCRYPTION,
        BACKGROUND_DISABLED;

    }
}

