/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class CompletableFutures {
    private static final CompletableFuture<Void> NULL_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    private static final CompletableFuture<Boolean> TRUE_COMPLETED_FUTURE = CompletableFuture.completedFuture(true);
    private static final CompletableFuture<Boolean> FALSE_COMPLETED_FUTURE = CompletableFuture.completedFuture(false);
    private static final CompletableFuture<List<?>> EMPTY_LIST_COMPLETED_FUTURE = CompletableFuture.completedFuture(List.of());
    private static final CompletableFuture<Set<?>> EMPTY_SET_COMPLETED_FUTURE = CompletableFuture.completedFuture(Set.of());
    private static final CompletableFuture<Map<?, ?>> EMPTY_MAP_COMPLETED_FUTURE = CompletableFuture.completedFuture(Map.of());

    public static <T> CompletableFuture<T> nullCompletedFuture() {
        return NULL_COMPLETED_FUTURE;
    }

    public static CompletableFuture<Boolean> trueCompletedFuture() {
        return TRUE_COMPLETED_FUTURE;
    }

    public static CompletableFuture<Boolean> falseCompletedFuture() {
        return FALSE_COMPLETED_FUTURE;
    }

    public static CompletableFuture<Boolean> booleanCompletedFuture(boolean b) {
        return b ? TRUE_COMPLETED_FUTURE : FALSE_COMPLETED_FUTURE;
    }

    public static <T> CompletableFuture<Collection<T>> emptyCollectionCompletedFuture() {
        return EMPTY_LIST_COMPLETED_FUTURE;
    }

    public static <T> CompletableFuture<List<T>> emptyListCompletedFuture() {
        return EMPTY_LIST_COMPLETED_FUTURE;
    }

    public static <T> CompletableFuture<Set<T>> emptySetCompletedFuture() {
        return EMPTY_SET_COMPLETED_FUTURE;
    }

    public static <K, V> CompletableFuture<Map<K, V>> emptyMapCompletedFuture() {
        return EMPTY_MAP_COMPLETED_FUTURE;
    }

    @SafeVarargs
    public static <T> CompletableFuture<List<T>> allOfToList(CompletableFuture<T> ... cfs) {
        return CompletableFuture.allOf(cfs).thenApply(v -> {
            ArrayList result = new ArrayList(cfs.length);
            for (CompletableFuture future : cfs) {
                result.add(future.join());
            }
            return result;
        });
    }

    public static CompletableFuture<Void> allOf(Collection<? extends CompletableFuture<?>> futures) {
        return futures.isEmpty() ? CompletableFutures.nullCompletedFuture() : CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public static CompletableFuture<Void> allOf(Stream<? extends CompletableFuture<?>> futures) {
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public static boolean isCompletedSuccessfully(CompletableFuture<?> future) {
        return future.isDone() && !future.isCompletedExceptionally() && !future.isCancelled();
    }

    public static <T> CompletableFuture<T> completedOrFailedFuture(@Nullable T result, @Nullable Throwable ex) {
        if (ex != null) {
            return CompletableFuture.failedFuture(ex);
        }
        return CompletableFuture.completedFuture(result);
    }

    public static <T> BiConsumer<T, Throwable> copyStateTo(CompletableFuture<? super T> future) {
        return (v, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
            } else {
                future.complete(v);
            }
        };
    }
}

