/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import javax.crypto.spec.SecretKeySpec;
import org.gridgain.internal.encryption.EncryptionManager;
import org.gridgain.internal.encryption.provider.DataEncryptionKey;
import org.rocksdb.KeyEncryptor;

public class KeyEncryptorAdapter
implements KeyEncryptor {
    private final EncryptionManager encryptionManager;

    public KeyEncryptorAdapter(EncryptionManager encryptionManager) {
        this.encryptionManager = encryptionManager;
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        assert (bytes.length == 16 || bytes.length == 24 || bytes.length == 32) : "Only AES keys with size 128/192/256 allowed.";
        SecretKeySpec key = new SecretKeySpec(bytes, "AES");
        DataEncryptionKey dk = new DataEncryptionKey(0, key);
        return this.encryptionManager.encryptDataKey(dk);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        DataEncryptionKey dk = this.encryptionManager.decryptDataKey(bytes);
        return dk.key().getEncoded();
    }
}

