/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.SpecialMethodInvocationException;
import org.apache.ignite.internal.network.serialization.marshal.DescribedObject;
import org.apache.ignite.internal.network.serialization.marshal.LocalDescriptors;
import org.apache.ignite.internal.network.serialization.marshal.MarshalException;
import org.jetbrains.annotations.Nullable;

class WriteReplacer {
    private final LocalDescriptors localDescriptors;

    WriteReplacer(LocalDescriptors localDescriptors) {
        this.localDescriptors = localDescriptors;
    }

    DescribedObject applyWriteReplaceIfNeeded(@Nullable Object objectBefore, ClassDescriptor descriptorBefore) throws MarshalException {
        if (!descriptorBefore.supportsWriteReplace()) {
            return new DescribedObject(objectBefore, descriptorBefore);
        }
        Object replacedObject = this.applyWriteReplace(objectBefore, descriptorBefore);
        ClassDescriptor replacementDescriptor = this.localDescriptors.getOrCreateDescriptor(replacedObject);
        if (descriptorBefore.describesSameClass(replacementDescriptor)) {
            return new DescribedObject(replacedObject, replacementDescriptor);
        }
        return this.applyWriteReplaceIfNeeded(replacedObject, replacementDescriptor);
    }

    @Nullable
    private Object applyWriteReplace(Object originalObject, ClassDescriptor originalDescriptor) throws MarshalException {
        try {
            return originalDescriptor.serializationMethods().writeReplace(originalObject);
        }
        catch (SpecialMethodInvocationException e) {
            throw new MarshalException("Cannot apply writeReplace()", (Throwable)e);
        }
    }
}

