/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectedMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectedMessageBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class HandshakeRejectedMessageDeserializer
implements MessageDeserializer<HandshakeRejectedMessage> {
    private final HandshakeRejectedMessageBuilder msg;

    HandshakeRejectedMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeRejectedMessage();
    }

    @Override
    public Class<HandshakeRejectedMessage> klass() {
        return HandshakeRejectedMessage.class;
    }

    @Override
    public HandshakeRejectedMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeRejectedMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("message");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.message(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("reasonString");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.reasonString(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeRejectedMessage.class);
    }
}

