/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.internal.future.OrderingFuture;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.netty.NettySender;
import org.apache.ignite.internal.network.netty.NettyUtils;
import org.apache.ignite.internal.network.netty.PipelineUtils;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.internal.network.serialization.SerializationService;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class NettyClient {
    private final Object startStopLock = new Object();
    private final SerializationService serializationService;
    private final SocketAddress address;
    private final CompletableFuture<Void> channelFuture = new CompletableFuture();
    private final Consumer<InNetworkObject> messageListener;
    private final HandshakeManager handshakeManager;
    @Nullable
    private volatile OrderingFuture<NettySender> senderFuture = null;
    @Nullable
    private volatile Channel channel = null;
    private volatile boolean stopped = false;
    @Nullable
    private final SslContext sslContext;

    public NettyClient(InetSocketAddress address, SerializationService serializationService, HandshakeManager manager, Consumer<InNetworkObject> messageListener, @Nullable SslContext sslContext) {
        this.address = address;
        this.serializationService = serializationService;
        this.handshakeManager = manager;
        this.messageListener = messageListener;
        this.sslContext = sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderingFuture<NettySender> start(Bootstrap bootstrapTemplate) {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.stopped) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Attempted to start an already stopped NettyClient");
            }
            if (this.senderFuture != null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Attempted to start an already started NettyClient");
            }
            Bootstrap bootstrap = bootstrapTemplate.clone();
            bootstrap.handler(new ChannelInitializer<SocketChannel>(){

                @Override
                public void initChannel(SocketChannel ch) {
                    PerSessionSerializationService sessionSerializationService = new PerSessionSerializationService(NettyClient.this.serializationService);
                    if (NettyClient.this.sslContext != null) {
                        PipelineUtils.setup(ch.pipeline(), sessionSerializationService, NettyClient.this.handshakeManager, NettyClient.this.messageListener, NettyClient.this.sslContext);
                    } else {
                        PipelineUtils.setup(ch.pipeline(), sessionSerializationService, NettyClient.this.handshakeManager, NettyClient.this.messageListener);
                    }
                }
            });
            CompletionStage senderCompletableFuture = ((CompletableFuture)NettyUtils.toChannelCompletableFuture(bootstrap.connect(this.address)).handle((channel, throwable) -> {
                Object object = this.startStopLock;
                synchronized (object) {
                    this.channel = channel;
                    if (throwable != null) {
                        this.channelFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        this.channelFuture.complete(null);
                    }
                    if (this.stopped) {
                        return CompletableFuture.failedFuture(new CancellationException("NettyClient was stopped"));
                    }
                    if (throwable != null) {
                        return CompletableFuture.failedFuture(throwable);
                    }
                    return this.handshakeManager.finalHandshakeFuture();
                }
            })).thenCompose(Function.identity());
            this.senderFuture = OrderingFuture.adapt(senderCompletableFuture);
            return this.senderFuture;
        }
    }

    public OrderingFuture<NettySender> sender() {
        Objects.requireNonNull(this.senderFuture, "NettyClient is not connected yet");
        return this.senderFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.stopped) {
                return CompletableFutures.nullCompletedFuture();
            }
            this.stopped = true;
            if (this.senderFuture == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            return ((CompletableFuture)this.channelFuture.handle((sender, throwable) -> this.channel == null ? CompletableFutures.nullCompletedFuture() : NettyUtils.toCompletableFuture(this.channel.close()))).thenCompose(Function.identity());
        }
    }

    public boolean failedToConnect() {
        OrderingFuture<NettySender> currentFuture = this.senderFuture;
        return currentFuture != null && currentFuture.isCompletedExceptionally();
    }

    public boolean isDisconnected() {
        Channel currentChannel = this.channel;
        return currentChannel != null && !currentChannel.isOpen() || this.stopped;
    }
}

