/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters.jmx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.apache.ignite.internal.metrics.CompositeMetric;
import org.apache.ignite.internal.metrics.DistributionMetric;
import org.apache.ignite.internal.metrics.DoubleMetric;
import org.apache.ignite.internal.metrics.IntMetric;
import org.apache.ignite.internal.metrics.LongMetric;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricManagerImpl;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.StringGauge;
import org.apache.ignite.internal.metrics.UuidGauge;

public class MetricSetMbean
implements DynamicMBean {
    private final MetricSet metricSet;

    public MetricSetMbean(MetricSet metricSet) {
        this.metricSet = metricSet;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        if ("MBeanInfo".equals(attribute)) {
            return this.getMBeanInfo();
        }
        Object metric = this.metricSet.get(attribute);
        if (metric == null) {
            throw new AttributeNotFoundException("Attribute not found [attribute=" + attribute + "]");
        }
        if (metric instanceof DoubleMetric) {
            return ((DoubleMetric)metric).value();
        }
        if (metric instanceof IntMetric) {
            return ((IntMetric)metric).value();
        }
        if (metric instanceof LongMetric) {
            return ((LongMetric)metric).value();
        }
        if (metric instanceof DistributionMetric) {
            return ((DistributionMetric)metric).value();
        }
        if (metric instanceof CompositeMetric) {
            String value = metric.getValueAsString();
            return value == null ? "" : value;
        }
        if (metric instanceof StringGauge) {
            return ((StringGauge)metric).value();
        }
        if (metric instanceof UuidGauge) {
            return ((UuidGauge)metric).value();
        }
        throw new AttributeNotFoundException("Unknown metric class [attribute=" + attribute + ", class=" + metric.getClass().getName() + "]");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        List<Attribute> attrList = list.asList();
        try {
            for (String attribute : attributes) {
                Object val = this.getAttribute(attribute);
                attrList.add(new Attribute(attribute, val));
            }
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return list;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if ("getAttribute".equals(actionName)) {
            try {
                return this.getAttribute((String)params[0]);
            }
            catch (AttributeNotFoundException e) {
                throw new MBeanException(e);
            }
        }
        throw new UnsupportedOperationException("The invoke is not supported [action=" + actionName + "]");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Iterator<Metric> iter = this.metricSet.iterator();
        ArrayList attrs = new ArrayList();
        iter.forEachRemaining(metric -> attrs.add(new MBeanAttributeInfo(metric.name(), MetricSetMbean.metricClass(metric), metric.description() != null ? metric.description() : metric.name(), true, false, false)));
        return new MBeanInfo(MetricManagerImpl.class.getName(), this.metricSet.description() != null ? this.metricSet.description() + " Source name: " + this.metricSet.name() : "Source name: " + this.metricSet.name(), attrs.toArray(new MBeanAttributeInfo[0]), null, null, null);
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new UnsupportedOperationException("setAttribute is not supported.");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("setAttributes is not supported.");
    }

    private static String metricClass(Metric metric) {
        if (metric instanceof DoubleMetric) {
            return Double.class.getName();
        }
        if (metric instanceof IntMetric) {
            return Integer.class.getName();
        }
        if (metric instanceof LongMetric) {
            return Long.class.getName();
        }
        if (metric instanceof DistributionMetric) {
            return long[].class.getName();
        }
        if (metric instanceof CompositeMetric) {
            return String.class.getName();
        }
        if (metric instanceof StringGauge) {
            return String.class.getName();
        }
        if (metric instanceof UuidGauge) {
            return UuidGauge.class.getName();
        }
        throw new IllegalArgumentException("Unknown metric class [class=" + metric.getClass().getName() + "]");
    }
}

